﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using EnvironmentReporting;
using System.Globalization;

namespace EnvironmentInformationProvider
{
    public class LocalesInformationProvider : IInformationProvider
    {
        public string InformationDescription { get { return "Locales"; } }

        public ContextInformation GetInformation()
        {
            var localeInfo = new ContextInformationContainer();

            localeInfo.Add("Middle East support enabled", new DecimalContextInformation(SystemInformation.MidEastEnabled ? 1 : 0));

            localeInfo.Add("DBCS support", new DecimalContextInformation(SystemInformation.DbcsEnabled ? 1 : 0));
            localeInfo.Add("Kanji window height", new DecimalContextInformation(SystemInformation.KanjiWindowHeight));

            localeInfo.Add("Current culture", InformationContainer(CultureInfo.CurrentCulture));
            localeInfo.Add("Current UI culture", InformationContainer(CultureInfo.CurrentUICulture));
            localeInfo.Add("Installed UI culture", InformationContainer(CultureInfo.InstalledUICulture));

            return localeInfo;
        }

        public static ContextInformation InformationContainer(CultureInfo cultureInfo)
        {
            var cultureInfoInfo = new ContextInformationContainer();

            cultureInfoInfo.Add("LICD", new DecimalContextInformation(cultureInfo.LCID));
            cultureInfoInfo.Add("Name", new StringContextInformation(cultureInfo.Name));
            cultureInfoInfo.Add("Number format", new StringContextInformation(cultureInfo.NumberFormat.ToString()));
            cultureInfoInfo.Add("Date format", new StringContextInformation(cultureInfo.DateTimeFormat.ToString()));
            cultureInfoInfo.Add("Keyboard layout id", new DecimalContextInformation(cultureInfo.KeyboardLayoutId));
            cultureInfoInfo.Add("Compare info", new StringContextInformation(cultureInfo.CompareInfo.ToString()));

            return cultureInfoInfo;
        }

        public static ContextInformation InformationContainer(NumberFormatInfo numberFormatInfo)
        {
            var numberFormatInfoInfo = new ContextInformationContainer();

            numberFormatInfoInfo.Add("Native digits", numberFormatInfo.NativeDigits.ToInformationContainer());

            numberFormatInfoInfo.Add("Negative sign", new StringContextInformation(numberFormatInfo.NegativeSign));
            numberFormatInfoInfo.Add("Positive sign", new StringContextInformation(numberFormatInfo.PositiveSign));
            numberFormatInfoInfo.Add("Negative infinity symbol", new StringContextInformation(numberFormatInfo.NegativeInfinitySymbol));
            numberFormatInfoInfo.Add("Positive infinity symbol", new StringContextInformation(numberFormatInfo.PositiveInfinitySymbol));
            numberFormatInfoInfo.Add("NaN symbol", new StringContextInformation(numberFormatInfo.NaNSymbol));

            {
                var numberInfo = new ContextInformationContainer();
                numberInfo.Add("Number decimal digits", new DecimalContextInformation(numberFormatInfo.NumberDecimalDigits));
                numberInfo.Add("Number decimal separator", new StringContextInformation(numberFormatInfo.NumberDecimalSeparator));
                numberInfo.Add("Number group separator", new StringContextInformation(numberFormatInfo.NumberGroupSeparator));
                numberInfo.Add("Number group sizes", numberFormatInfo.NumberGroupSizes.ToInformationContainer());

                string[] negativePatternStrings = { "(n)", "-n", "- n", "n-", "n -" };
                numberInfo.Add("Number negative pattern", new StringContextInformation(negativePatternStrings[numberFormatInfo.NumberNegativePattern]));

                numberFormatInfoInfo.Add("Number", numberInfo);
            }
            {
                var currencyInfo = new ContextInformationContainer();
                currencyInfo.Add("Currency decimal digits", new DecimalContextInformation(numberFormatInfo.CurrencyDecimalDigits));
                currencyInfo.Add("Currency decimal separator", new StringContextInformation(numberFormatInfo.CurrencyDecimalSeparator));
                currencyInfo.Add("Currency group separator", new StringContextInformation(numberFormatInfo.CurrencyGroupSeparator));
                currencyInfo.Add("Currency group sizes", numberFormatInfo.CurrencyGroupSizes.ToInformationContainer());

                string[] negativePatternStrings = { "($n)", "-$n", "$-n", "$n-", "(n$)", "-n$", "n-$", "n$-", "-n $", "-$ n", "n $-", "$ n-", "$ -n", "n- $", "($ n)", "(n $)" };
                currencyInfo.Add("Currency negative pattern", new StringContextInformation(negativePatternStrings[numberFormatInfo.CurrencyNegativePattern]));

                string[] positivePatternStrings = { "$n", "n$", "$ n", "$ n" };
                currencyInfo.Add("Currency positive pattern", new StringContextInformation(positivePatternStrings[numberFormatInfo.CurrencyPositivePattern]));

                currencyInfo.Add("Currency symbol", new StringContextInformation(numberFormatInfo.CurrencySymbol));

                numberFormatInfoInfo.Add("Currency", currencyInfo);
            }
            {
                var percentInfo = new ContextInformationContainer();
                percentInfo.Add("Percent decimal digits", new DecimalContextInformation(numberFormatInfo.PercentDecimalDigits));
                percentInfo.Add("Percent decimal separator", new StringContextInformation(numberFormatInfo.PercentDecimalSeparator));
                percentInfo.Add("Percent group separator", new StringContextInformation(numberFormatInfo.PercentGroupSeparator));
                percentInfo.Add("Percent group sizes", numberFormatInfo.PercentGroupSizes.ToInformationContainer());

                string[] negativePatternStrings = { "-n %", "-n%", "-%n", "%-n", "%n-", "n-%", "n%-", "-% n", "n %-", "% n-", "% -n", "n- %" };
                percentInfo.Add("Percent negative pattern", new StringContextInformation(negativePatternStrings[numberFormatInfo.PercentNegativePattern]));

                string[] positivePatternStrings = { "n %", "n%", "%n", "% n" };
                percentInfo.Add("Percent positive pattern", new StringContextInformation(positivePatternStrings[numberFormatInfo.PercentPositivePattern]));

                percentInfo.Add("Percent symbol", new StringContextInformation(numberFormatInfo.PercentSymbol));

                numberFormatInfoInfo.Add("Percent", percentInfo);
            }
            numberFormatInfoInfo.Add("Per mille symbol", new StringContextInformation(numberFormatInfo.PerMilleSymbol));

            return numberFormatInfoInfo;
        }
    }
}
