﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

using EnvironmentReporting;

namespace EnvironmentInformationProvider
{
    public class KeyboardInformationProvider : IInformationProvider
    {
        public string InformationDescription { get { return "Keyboard"; } }

        const int KL_NAMELENGTH = 9;

        [DllImport("user32.dll")]
        private static extern long GetKeyboardLayoutName(System.Text.StringBuilder pwszKLID);

        public ContextInformation GetInformation()
        {
            var keyboardInfo = new ContextInformationContainer();

            keyboardInfo.Add("Keyboard delay (0 - 3)", new DecimalContextInformation(SystemInformation.KeyboardDelay));
            keyboardInfo.Add("Keyboard speed (0 - 31)", new DecimalContextInformation(SystemInformation.KeyboardSpeed));
            keyboardInfo.Add("Keyboard preferred", new DecimalContextInformation(SystemInformation.IsKeyboardPreferred ? 1 : 0));

            StringBuilder keyboardLayoutName = new StringBuilder(KL_NAMELENGTH);
            GetKeyboardLayoutName(keyboardLayoutName);
            keyboardInfo.Add("Keyboard layout", new StringContextInformation(keyboardLayoutName.ToString()));

            return keyboardInfo;
        }
    }
}
