﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;

using EnvironmentReporting;

namespace EnvironmentInformationProvider
{
    internal static class Extensions
    {
        public static ContextInformationContainer ToInformationContainer(this Size size)
        {
            var sizeInfo = new ContextInformationContainer();
            sizeInfo.Add("Width", new DecimalContextInformation(size.Width));
            sizeInfo.Add("Height", new DecimalContextInformation(size.Height));
            return sizeInfo;
        }

        public static ContextInformationContainer ToInformationContainer(this Rectangle rect)
        {
            var rectInfo = new ContextInformationContainer();
            rectInfo.Add("X", new DecimalContextInformation(rect.X));
            rectInfo.Add("Y", new DecimalContextInformation(rect.Y));
            rectInfo.Add("Width", new DecimalContextInformation(rect.Width));
            rectInfo.Add("Height", new DecimalContextInformation(rect.Height));
            return rectInfo;
        }

        public static ContextInformationContainer ToInformationContainer(this int[] array)
        {
            var arrayInfo = new ContextInformationContainer();
            for (int i = 0; i < array.Length; ++i)
                arrayInfo.Add(i.ToString(), new DecimalContextInformation(array[i]));
            return arrayInfo;
        }

        public static ContextInformationContainer ToInformationContainer(this string[] array)
        {
            var arrayInfo = new ContextInformationContainer();
            for (int i = 0; i < array.Length; ++i)
                arrayInfo.Add(i.ToString(), new StringContextInformation(array[i]));
            return arrayInfo;
        }
    }
}
