﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Globalization;

namespace EffectDefinitions
{
    public static class Utility
    {
        public static string ValidIdentifierRegEx = "^[a-zA-Z_][a-zA-Z0-9_]*$";

        public static bool IsEDMLFileName(string pattern)
        {
            return pattern.EndsWith(".edml", true, CultureInfo.InstalledUICulture);
        }

        public static float GetSimilarity(string string1, string string2)
        {
            var maxLen = Math.Max(string1.Length, string2.Length);

            if (maxLen == 0)
                return 1.0f;

            float dist = ComputeStringSimilarityDistance(string1, string2);

            return 1.0f - dist / maxLen;
        }

        private static int ComputeStringSimilarityDistance(string s, string t)
        {
            if (s == null)
                throw new ArgumentNullException("s");
            if (t == null)
                throw new ArgumentNullException("t");

            var n = s.Length;
            var m = t.Length;

            if (n == 0)
                return m;
            if (m == 0)
                return n;

            var distance = new int[n + 1, m + 1];

            //init
            for (var i = 0; i <= n; distance[i, 0] = i++)
            {
            }
            for (var j = 0; j <= m; distance[0, j] = j++)
            {
            }

            //find min distance
            for (var i = 1; i <= n; i++)
            {
                for (var j = 1; j <= m; j++)
                {
                    var cost = t.Substring(j - 1, 1) == s.Substring(i - 1, 1) ? 0 : 1;
                    distance[i, j] = Math.Min(distance[i - 1, j] + 1, Math.Min(distance[i, j - 1] + 1, distance[i - 1, j - 1] + cost));
                }
            }

            return distance[n, m];
        }
    }
}
