﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectDefinitions
{
    /// <summary>
    /// Definition of a function binding: it has a source, and the id and name of the function.
    /// </summary>
    public class FunctionBinding
    {
        public FunctionBinding(DefinitionLocation source,
            DefinitionLocation idSource, string id,
            DefinitionLocation nameSource, string name)
        {
            if (string.IsNullOrWhiteSpace(id))
                throw new ArgumentException(string.Format(Messages.EXCEPTION_INVALID_ARGUMENT, "id"), "id");

            Source = source;
            IdSource = idSource;
            NameSource = nameSource;

            Id = id;
            Name = name;
        }

        public DefinitionLocation Source { get; private set; }
        public DefinitionLocation IdSource { get; private set; }
        public DefinitionLocation NameSource { get; private set; }

        public string Id { get; private set; }
        public string Name { get; private set; }

        public FunctionDefinition Definition { get; internal set; }

        public override string ToString()
        {
            return string.Format("{0} ({1})", Id, Definition == null ? "not bound" : "bound");
        }
    }
}
