﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.ObjectModel;

namespace EffectDefinitions
{
    internal class ErrorContainer : IErrorReporter
    {
        public IEnumerable<Error> Errors { get; private set; }
        private readonly List<Error> errors = new List<Error>();
        private List<Error> GlobalErrorsList { get; set; }

        public ErrorContainer(List<Error> globalErrorsList)
        {
            Errors = new ReadOnlyCollection<Error>(errors);
            GlobalErrorsList = globalErrorsList;
        }

        public void Report(Error error) { errors.Add(error); GlobalErrorsList.Add(error); }

        public void ClearErrors()
        {
            errors.Clear();
        }
    }
}
