﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectCombiner.Core
{
    public class ProgressionReporter
    {
        public int Maximum { get; private set; }
        public int Current { get; private set; }
        public string Message { get; private set; }

        public ProgressionReporter(int maximum)
        {
            Maximum = maximum;
        }

        public void UpdateMaximum(int newMaximum)
        {
            if (Maximum == newMaximum)
                return;

            Maximum = newMaximum;

            var handler = MaximumChanged;
            if (handler != null)
                handler(this, EventArgs.Empty);
        }

        public void ReportProgression(int current, string message)
        {
            Current = current;
            Message = message;

            var handler = ProgressionChanged;
            if (handler != null)
                handler(this, EventArgs.Empty);
        }

        public event EventHandler ProgressionChanged;
        public event EventHandler MaximumChanged;
    }
}
