﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Blocks.Core;
using EffectCombiner.Primitives.Extensions;
using EffectCombiner.Primitives.Generation;
using Renderer2D.Core;

namespace EffectCombiner.Primitives.Operations
{
    public class CommentTextChangeOperation : OperationBase
    {
        private readonly uint instanceIdentifier;
        private readonly string newValue;
        private readonly string oldValue;
        private readonly ISize newSize;
        private readonly ISize oldSize;

        public CommentTextChangeOperation(
            BlockManagerBase blockManager, BlockElementBase commentBlockElement,
            string oldValue, ISize oldSize, string newValue, ISize newSize)
            : base(OperationType.CommentTextChange, blockManager)
        {
            if (commentBlockElement == null)
                throw new ArgumentNullException("commentBlockElement");
            if (newValue == null)
                throw new ArgumentNullException("newValue");
            if (oldValue == null)
                throw new ArgumentNullException("oldValue");

            this.instanceIdentifier = commentBlockElement.InstanceIdentifier;
            this.newValue = newValue;
            this.newSize = newSize;
            this.oldValue = oldValue;
            this.oldSize = oldSize;
        }

        public override void Rollback()
        {
            var block = FindBlock<CommentBlockElement>(instanceIdentifier);

            block.Text = oldValue;
            block.SetComputedSize(oldSize.Width, oldSize.Height);
            Globals.WorkspaceManager.InvalidateRender();
            if (block.IsSelected && Globals.CommentTextPanel.GetBlockElement() == block)
            {
                block.IsSelected = false;
                block.IsSelected = true;
                Globals.CommentTextPanel.SetBlockElement(block);
            }
        }

        public override void Execute()
        {
            var block = FindBlock<CommentBlockElement>(instanceIdentifier);

            block.Text = newValue;
            block.SetComputedSize(newSize.Width, newSize.Height);
            Globals.WorkspaceManager.InvalidateRender();
            if (block.IsSelected && Globals.CommentTextPanel.GetBlockElement() == block)
            {
                block.IsSelected = false;
                block.IsSelected = true;
                Globals.CommentTextPanel.SetBlockElement(block);
            }
        }
    }
}
