﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Blocks.Core;
using System.Drawing.Drawing2D;

namespace EffectCombiner.Primitives.Blocks.BlockHitTesters
{
    public abstract class PathBlockHitTesterBase : IBlockHitTester
    {
        private GraphicsPath blockPath;
        private readonly List<GraphicsPath> inputPaths = new List<GraphicsPath>();
        private readonly List<GraphicsPath> outputPaths = new List<GraphicsPath>();

        protected void SetBlockPath(GraphicsPath path)
        {
            if (path == null)
                throw new ArgumentNullException("path");
            blockPath = path;
        }

        protected void AddInputPath(GraphicsPath path)
        {
            if (path == null)
                throw new ArgumentNullException("path");
            inputPaths.Add(path);
        }

        protected void ClearInputs()
        {
            inputPaths.Clear();
        }

        protected void AddOutputPath(GraphicsPath path)
        {
            if (path == null)
                throw new ArgumentNullException("path");
            outputPaths.Add(path);
        }

        protected void ClearOutputs()
        {
            outputPaths.Clear();
        }

        public bool HitTest(double x, double y)
        {
            if (blockPath == null)
                return false;
            return blockPath.IsVisible((float)x, (float)y);
        }

        public PlugHitTestResult PlugHitTest(double x, double y, out int plugIndex)
        {
            plugIndex = -1;

            var xx = (float)x;
            var yy = (float)y;

            for (var i = 0; i < inputPaths.Count; i++)
            {
                if (inputPaths[i].IsVisible(xx, yy))
                {
                    plugIndex = i;
                    return PlugHitTestResult.Input;
                }
            }

            for (var i = 0; i < outputPaths.Count; i++)
            {
                if (outputPaths[i].IsVisible(xx, yy))
                {
                    plugIndex = i;
                    return PlugHitTestResult.Output;
                }
            }

            return PlugHitTestResult.None;
        }
    }
}
