﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectDefinitions;

namespace EffectCombiner.Primitives.Generation.Usage
{
    public interface IUsageDescriptor
    {
        string Name { get; }
        ShaderTyping.ShaderTypeDefinition Type { get; }

        /// <summary>
        /// Called to generate the virtual sub plugs related to the input plug.
        /// </summary>
        /// <param name="originalInputPlug">The plug that might be expanded.</param>
        /// <returns>Returns null or an empty array if nothing to expand,
        /// or an array of SubPlug, not including the original plug.</returns>
        SubPlug[] ExpandInput(Plug originalInputPlug);
        /// <summary>
        /// Called to generate the virtual sub plugs related to the output plug.
        /// </summary>
        /// <param name="originalOutputPlug">The plug that might be expanded.</param>
        /// <returns>Returns null or an empty array if nothing to expand,
        /// or an array of SubPlug, not including the original plug.</returns>
        SubPlug[] ExpandOutput(Plug originalOutputPlug);

        /// <summary>
        /// Determine if a set of plugs make a proper connection.
        /// </summary>
        /// <param name="originalPlug">The original plug.</param>
        /// <param name="subPlugs">The virtual sub plugs related to the original one.</param>
        /// <returns>Returns true if the set make a proper connection, false otherwise.</returns>
        bool AreInputsProperlyConnected(EffectInputPlug originalPlug, EffectInputPlug[] subPlugs);
        /// <summary>
        /// Determine if a set of plugs make a proper connection.
        /// </summary>
        /// <param name="originalPlug">The original plug.</param>
        /// <param name="subPlugs">The virtual sub plugs related to the original one.</param>
        /// <returns>Returns true if the set make a proper connection, false otherwise.</returns>
        bool AreOutputsProperlyConnected(EffectOutputPlug originalPlug, EffectOutputPlug[] subPlugs);
    }
}
