﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Linq;
using EffectDefinitions;

namespace EffectCombiner.Primitives.Generation
{
    public class ConstantFunctionDefinition : FunctionDefinition
    {
        public ConstantFunctionDefinition(ShaderTypeDefinition returnType)
            : base(null, "const_func", "const_func",
            returnType,
            null, null, null)
        {
        }
    }

    /// <summary>
    /// 定数ブロックです。
    /// </summary>
    public class ConstantBlockDefinition : BlockDefinition
    {
        /// <summary>
        /// GUIDです。
        /// </summary>
        public static readonly string ConstantBlockDefinitionGuid = "{6F1DB2BF-631D-4DAF-BC91-55440485A79E}";

        /// <summary>
        /// ConstantBlockにつけるタグ名です。
        /// </summary>
        private static readonly string[] tags = { "Input" };

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="returnType">定数の型</param>
        public ConstantBlockDefinition(ShaderTypeDefinition returnType)
            : base(
            null,
            Messages.TEXT_BLOCK_NAME_CONSTANT,
            ConstantBlockDefinitionGuid,
            string.Empty,
            new Plug[0],
            new[] { new Plug("Value", returnType, ParameterDefinition.ReturnParameterString, false, null, null) },
            null,
            new PreviewDefinition(),
            new FunctionBinding(null, null, "const_func", null, "const_func"))
        {
            this.FunctionDefinition = new ConstantFunctionDefinition(returnType);
            this.BindToFunctionDefinition(this.FunctionDefinition);
            this.ParameterText = "Value";

            // TODO: update block name at runtime
            // Globals.Localization.CultureChanged += (ss, ee) => Name = Messages.TEXT_BLOCK_NAME_CONSTANT;
        }

        public ConstantFunctionDefinition FunctionDefinition { get; private set; }

        /// <summary>
        /// Tags of the active function definition.
        /// </summary>
        public override IEnumerable<string> Tags
        {
            get
            {
                return this.IsBound ? tags : Enumerable.Empty<string>();
            }
        }

        /// <summary>
        /// Constant値のパラメータです。
        /// </summary>
        public string ParameterText
        {
            get;
            set;
        }
    }
}
