﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectDefinitions;

namespace EffectCombiner.Primitives.Generation.AutoGen.Operators
{
    public class SubOperatorDefinitionSet : IAutoDefinitionSet
    {
        public SubOperatorDefinitionSet()
        {
            var paramNames = new[] { "a", "b" };

            var supportedFunctionPrototypes = new[]
            {
                new[] { "int", "int", "int" },
                new[] { "uint", "uint", "uint" },
                new[] { "float", "float", "float" },
                new[] { "double", "double", "double" },
                new[] { "ivec2", "ivec2", "ivec2" },
                new[] { "ivec3", "ivec3", "ivec3" },
                new[] { "ivec4", "ivec4", "ivec4" },
                new[] { "uvec2", "uvec2", "uvec2" },
                new[] { "uvec3", "uvec3", "uvec3" },
                new[] { "uvec4", "uvec4", "uvec4" },
                new[] { "vec2", "vec2", "vec2" },
                new[] { "vec3", "vec3", "vec3" },
                new[] { "vec4", "vec4", "vec4" },
                new[] { "dvec2", "dvec2", "dvec2" },
                new[] { "dvec3", "dvec3", "dvec3" },
                new[] { "dvec4", "dvec4", "dvec4" },
                new[] { "ivec2", "ivec2", "int" },
                new[] { "ivec3", "ivec3", "int" },
                new[] { "ivec4", "ivec4", "int" },
                new[] { "uvec2", "uvec2", "uint" },
                new[] { "uvec3", "uvec3", "uint" },
                new[] { "uvec4", "uvec4", "uint" },
                new[] { "vec2", "vec2", "float" },
                new[] { "vec3", "vec3", "float" },
                new[] { "vec4", "vec4", "float" },
                new[] { "dvec2", "dvec2", "double" },
                new[] { "dvec3", "dvec3", "double" },
                new[] { "dvec4", "dvec4", "double" },
            };

            FunctionDefinitions = OperatorDefinitionSetUtility.CreateFunctions(this, supportedFunctionPrototypes, paramNames);

            BlockDefinition = new PolymorphicBlockDefinition(BlockName, Guid, FunctionDefinitions);
            ShaderCodes = FunctionDefinitions
                .Select(fd => OperatorDefinitionSetUtility.CreateShaderCode(fd, "-"))
                .ToArray();
        }

        public string Guid
        {
            get { return "{78B8B0E7-09FE-4ADE-A211-4C9C5B55E3B2}"; }
        }

        public string FunctionName
        {
            get { return "Sub"; }
        }

        public string BlockName
        {
            get { return "Sub"; }
        }

        public FunctionDefinition[] FunctionDefinitions { get; private set; }
        public PolymorphicBlockDefinition BlockDefinition { get; private set; }
        public string[] ShaderCodes { get; private set; }
    }
}
