﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectCombiner.Primitives.Generation.AutoGen.Operators
{
    public class SmoothStepOperatorDefinitionSet : BuiltInFunctionDefinitionSet
    {
        public SmoothStepOperatorDefinitionSet()
            : base(
            "smoothstep",
            "Smooth Step",
            "{DD1224C1-F602-4250-AD87-2AD90C1B90D9}",
            new[] { "min", "max", "x" },
            new[]
            {
                new[] { "float", "float", "float", "float" },
                new[] { "vec2", "vec2", "vec2", "vec2" },
                new[] { "vec3", "vec3", "vec3", "vec3" },
                new[] { "vec4", "vec4", "vec4", "vec4" },
                new[] { "double", "double", "double", "double" },
                new[] { "dvec2", "dvec2", "dvec2", "dvec2" },
                new[] { "dvec3", "dvec3", "dvec3", "dvec3" },
                new[] { "dvec4", "dvec4", "dvec4", "dvec4" },
                new[] { "vec2", "float", "float", "vec2" },
                new[] { "vec3", "float", "float", "vec3" },
                new[] { "vec4", "float", "float", "vec4" },
                new[] { "dvec2", "double", "double", "dvec2" },
                new[] { "dvec3", "double", "double", "dvec3" },
                new[] { "dvec4", "double", "double", "dvec4" },
            })
        {
        }
    }
}
