﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectCombiner.Editor.OptionPanes
{
    /// <summary>
    /// オプションペインのインターフェースです。
    /// </summary>
    public interface IOptionPane
    {
        /// <summary>
        /// オプションペインの識別名を取得します。
        /// </summary>
        string Identifier { get; }

        /// <summary>
        /// このオプションペインの親ノードになるペインの識別名を取得します。
        /// ルートペインのときはnullを返します。
        /// </summary>
        string ChildOf { get; }

        /// <summary>
        /// オプションダイアログに表示するノード名を取得します。
        /// </summary>
        string DisplayName { get; }

        /// <summary>
        /// オプションペインを生成したときの処理を行います。
        /// </summary>
        void OnInitialize();

        /// <summary>
        /// オプションダイアログを閉じたときの処理を行います。
        /// </summary>
        void OnTerminate();

        /// <summary>
        /// オプションダイアログのOKボタンを押したときの処理を行います。
        /// </summary>
        void OnAccept();

        /// <summary>
        /// オプションダイアログのキャンセルボタンを押したときの処理を行います。
        /// </summary>
        void OnCancel();
    }

    [AttributeUsage(AttributeTargets.Class, AllowMultiple = false, Inherited = false)]
    public class DisplayOrderAttribute : Attribute
    {
        public int Value { get; private set; }

        public DisplayOrderAttribute(int value)
        {
            Value = value;
        }
    }
}
