﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Nintendo.Foundation.IO;

namespace EffectCombiner.Editor.CommandLine
{
    /// <summary>
    /// コマンドラインパラメータです。
    /// </summary>
    public class CommandLineParams
    {
        /// <summary>
        /// サイレントモードかどうか取得または設定します。
        /// </summary>
        [CommandLineOption('s', "silent", Description = "ConsoleDescSilent", DescriptionConverterName = "LocalizeDescription")]
        public bool IsSilentMode { get; set; }

        /// <summary>
        /// コンソールの自動割り当てを無効化するかどうか取得または設定します。
        /// </summary>
        [CommandLineOption("disable-alloc-console", Description = "ConsoleDescDisableAllocConsole", DescriptionConverterName = "LocalizeDescription")]
        public bool DisableAllocConsole { get; set; }

        /// <summary>
        /// プロジェクト設定ファイルを取得または設定します。
        /// </summary>
        [CommandLineOption("team-setting-file", Description = "ConsoleDescProjectConfig", ValueName = "setting.xml", DescriptionConverterName = "LocalizeDescription")]
        public string ProjectConfigFile { get; set; }

        /// <summary>
        /// コンバートするecmbファイルのパスを取得または設定します。
        /// </summary>
        [CommandLineOption('i', "input", Description = "ConsoleDescInputFile", ValueName = "input.ecmb", DescriptionConverterName = "LocalizeDescription")]
        public string InputFile { get; set; }

        /// <summary>
        /// シェーダコードの出力パスを取得または設定します。
        /// </summary>
        [CommandLineOption('o', "output", Description = "ConsoleDescShaderOutput", ValueName = "output.glsl", DescriptionConverterName = "LocalizeDescription")]
        public string OutputFile { get; set; }

        /// <summary>
        /// シェーダ環境のパスを取得または設定します。
        /// </summary>
        [CommandLineOption("shader-env-path", Description = "ConsoleDescShaderEnvironmentPath", ValueName = "shaderEnvironmentDirectory", DescriptionConverterName = "LocalizeDescription")]
        public string ShaderEnvironmentPath { get; set; }

        /// <summary>
        /// ローカライズしたオプションの説明を取得します。
        /// </summary>
        /// <param name="description">Descriptionプロパティの値</param>
        /// <param name="valueName">引数名またはオプション名</param>
        /// <returns>ローカライズされたコマンドラインオプションの説明を返します。</returns>
        public static string LocalizeDescription(string description, string valueName)
        {
            string result = Properties.Resources.ResourceManager.GetString(description, Properties.Resources.Culture);
            System.Diagnostics.Debug.Assert(result != null, "コマンドオプションの Description が null");

            return result;
        }
    }
}
