﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Xml.Serialization;

namespace EffectCombiner.Data.Processors.Version2
{
    public class WorkflowProcessor : IWorkflowProcessor
    {
        private const ushort ProcessorVersion = 2;

        public ushort Version
        {
            get { return ProcessorVersion; }
        }

        private IWorkflowDataEventReporter localReporter;

        public void SetReporter(IWorkflowDataEventReporter reporter)
        {
            localReporter = reporter;
        }

        public object Load(Stream input)
        {
            return WorkflowDataHelper.Deserialize<ProjectV2>(input, localReporter);
        }

        public void Save(Stream output, object workflow)
        {
            WorkflowDataHelper.Serialize<ProjectV2>(output, workflow, localReporter);
        }
    }
}
