﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectCombiner.BlockAssistant
{
    public class ReportEventArgs : EventArgs
    {
        public Report Report { get; private set; }

        public ReportEventArgs(Report report)
        {
            if (report == null)
                throw new ArgumentNullException(string.Format(Localization.Messages.EXCEPTION_INVALID_ARGUMENT, "report"));

            Report = report;
        }
    }

    public class ParsingEventArgs : EventArgs
    {
        public ParseInfo Info { get; private set; }

        public ParsingEventArgs(ParseInfo parseInfo)
        {
            Info = parseInfo;
        }
    }
}
