﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//=============================================================================
// include
//=============================================================================
#include "PIDefines.h"
#include "PIActions.h"
#include "PITerminology.h"
#include "NintendoNormalMapFilterCommand.h"

#ifndef Rez
    #include "NintendoNormalMapFilter.h"
#endif

//=============================================================================
// constants
//=============================================================================
#define vendorName          "Nintendo"
#define plugInName          "Nintendo Normal Map Filter"
#define plugInAETEComment   "Nintendo Normal Map Filter Plugin"

#define plugInSuiteID       'nwfP'
#define plugInClassID       'nrmF'
#define plugInEventID       plugInClassID
#define plugInUniqueID      nnNormalMapFilterUniqueID

#define plugInCopyrightYear  "2015"
#define plugInDescription \
    "Nintendo Normal Map Filter Plugin for Adobe Photoshop."

//=============================================================================
// functions
//=============================================================================
#ifndef Rez
OSErr ReadScriptParameters(GPtr globals);
OSErr WriteScriptParameters(GPtr globals);
#endif

