﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//=============================================================================
// include
//=============================================================================
#include "Globals.h"

//=============================================================================
// external functions
//=============================================================================

//! @brief プラグインのメイン関数です。
#if (PS_API_VERSION >= 1100)
DLLExport MACPASCAL void PluginMain(
    const int16 selector,
    FilterRecordPtr filterParamBlock,
    intptr_t* data,
    int16* result
);
#else
DLLExport MACPASCAL void PluginMain(
    const int16 selector,
    void* filterParamBlock,
    int32* data,
    int16* result
);
#endif

//! @brief フィルタ処理を実行します。
bool DoFilter(
    GPtr globals,
    uint8_t* pDstData,
    const uint8_t* pBinaryData,
    const int curW,
    const int curH,
    const int fullW,
    const bool isRough,
    nn::gfx::tool::nps::RProgress* pProgress = NULL
);

