-- NintendoExport Material Options Script
-- Version 3.12.0
-- Copyright (C)Nintendo All rights reserved.

rcMenu nw4fMaterialMenu
(
	subMenu "Help" 
	(
		menuItem mi_Help "Help On Set Material Attribute..."
	)
	on mi_Help picked do nintendoExportRollout.showHelp @"html\NW4F_SetMaterialAttr.html"
)
rollout nw4fMaterialRollout "Set Material Attribute" width:480 --height:550
(
	--groupBox grp1 "Selected Material" pos:[8,8] width:464 height:170
	group"Selected Material"
	(
	--label lblSelectedNode "" pos:[16,24] width:368 height:64
	dotNetControl lv_mtl "System.Windows.Forms.ListView" pos:[16,24] width:450 height:150
	)
	--
	--groupBox grp2 "Set" pos:[8,184] width:464 height:126
	group "Set"
	(
--	dropDownList ddlSetFaceCulling "Face Culling" pos:[16,200] width:152 height:41 \
--			items:#("Back Face", "Front Face", "Always", "Never")
	dropDownList ddlSetCompress "Compress" width:152 height:41 \
			items:#("Compress if possible", "Don't compress")
/*
	checkbox chkSetFragmentLighting "Fragment Lighting" pos:[16,244] width:152 height:16
	checkbox chkSetVertexLighting "Vertex Lighting" pos:[184,244] width:152 height:16
	dropDownList ddlSetBlendMode "Blend Mode" pos:[16,264] width:152 height:41 \
			items:#("Auto", "Opaque", "Alpha Test", "Translucent", "Add", "Sub", "Multiply")
*/
	)
	--
	--groupBox grp3 "Search" pos:[8,318] width:464 height:200
	group "Search"
	(
/*
	label lbl2 "Face Culling" pos:[16,334] width:80 height:16
	checkbox chkSFC_Front "Front Face" pos:[144,334] width:80 height:16
	checkbox chkSFC_Back "Back Face" pos:[224,334] width:80 height:16
	checkbox chkSFC_Always "Always" pos:[304,334] width:64 height:16
	checkbox chkSFC_Never "Never" pos:[368,334] width:56 height:16
	label lbl3 "Fragment Lighting" pos:[16,358] width:120 height:16
	checkbox chkSFL_Off "off" pos:[144,358] width:48 height:16
	checkbox chkSFL_On "on" pos:[192,358] width:40 height:16
	label lbl4 "Vertex Lighting" pos:[16,382] width:120 height:16
	checkbox chkSVL_Off "off" pos:[144,382] width:48 height:16
	checkbox chkSVL_On "on" pos:[192,382] width:40 height:16
*/
		label lbl5 "Compress  " height:16 align:#right across:4
		checkbox chkSC_On "If possible" width:80 height:16 align:#left
		checkbox chkSC_Off "Don't" width:104 height:16 align:#left
		label lblDummy5 ""

/*
	label lbl6 "Blend Mode" pos:[16,430] width:120 height:16
	checkbox chkBM_Auto "Auto" pos:[144,430] width:80 height:16
	checkbox chkBM_Opaque "Opaque" pos:[224,430] width:80 height:16
	checkbox chkBM_AlphaTest "Alpha Test" pos:[304,430] width:80 height:16
	checkbox chkBM_Translucent "Translucent" pos:[144,454] width:80 height:16
	checkbox chkBM_Add "Add" pos:[234,454] width:60 height:16
	checkbox chkBM_Sub "Sub" pos:[294,454] width:60 height:16
	checkbox chkBM_Multiply "Multiply" pos:[358,454] width:80 height:16
*/	
	--
	--radioButtons rdoSearchType "" pos:[192,494] width:98 height:16 labels:#("AND", "OR") columns:2
		button btnSearch "Search" width:160 align:#right
	)
	
	button btnClose "Close" width:464 height:24

	local donotRedraw
	local mtls = #()
	local nodeCallbacks =#()
	fn initListView =
	(
		lv_mtl.gridLines = true
		lv_mtl.View = (dotNetClass "System.Windows.Forms.View").Details
		lv_mtl.fullRowSelect = true
		lv_mtl.AutoSize = true
		lv_mtl.MultiSelect = false
		lv_mtl.Columns.add "Material Name" 
		--lv_mtl.Columns.add "Face Culling" 
		--lv_mtl.Columns.add "Fragment" 
		--lv_mtl.Columns.add "Vertex" 
		lv_mtl.Columns.add "Compress     "
		--lv_mtl.Columns.add "BlendMode"
		lv_mtl.sorting = (dotNetClass "System.Windows.Forms.SortOrder").Ascending
		lv_mtl.AutoResizeColumns ((dotNetClass "System.Windows.Forms.ColumnHeaderAutoResizeStyle").HeaderSize)
	)

	fn getMtlAttribute m create =
	(
		local attrib = m.custAttributes["NW4F Material Custom Attribute"]
		if attrib == undefined then
		(
			--if not create do return undefined 
			attrib = nw4f_mtl_custom_attribute()
			append m.custAttributes attrib
		)
		return attrib
	)

	fn getSelMtls sel = 
	(
		local smtls = #()
		for n in sel do
		(
			local mtl = n.material
			if mtl != undefined do
			(
				appendIfUnique smtls mtl
				if(classOf mtl == Multimaterial) do
				(
					for submtl in mtl.materialList do
					(
						appendIfUnique smtls submtl
					)
				)
			)
		)
		return smtls
	)
	
	fn enableUI flag =
	(
		--ddlSetFaceCulling.enabled = flag
		ddlSetCompress.enabled = flag
		--chkSetFragmentLighting.enabled = flag
		--chkSetVertexLighting.enabled = flag
		--ddlSetBlendMode.enabled = flag
	)
	
	fn loadAttributeToUI attr =
	(
		if (classof attr) != nw4f_mtl_custom_attribute do return()
		
		--ddlSetFaceCulling.selection = attr.faceCulling + 1
		ddlSetCompress.selection = attr.compress + 1
		--chkSetFragmentLighting.checked = attr.fragmentLighting
		--chkSetVertexLighting.checked = attr.vertexLighting
		--ddlSetBlendMode.selection = attr.blendMode + 1
	)

	fn updateSelection =
	(
		if donotRedraw do return()
		lv_mtl.Items.Clear()
		--print "updateSelection"
		--print mtls

		local str = ""
		--local mtls = getSelMtls selection
		
		local lvItems =#()
		for m in mtls do
		(
			local attr = getMtlAttribute m true

			local li = dotNetObject "System.Windows.Forms.ListViewItem" m.name
			local sub_li 
			/*
			str = case attr.faceCulling of
				(
					0: "Back Face"
					1: "Front Face"
					2: "Always"
					default: "Never"
				)
			sub_li = li.SubItems.add str
			
			sub_li = li.SubItems.add (if attr.fragmentLighting then "on" else "off")
			sub_li = li.SubItems.add (if attr.vertexLighting then "on" else "off")
			*/
			str = case attr.compress of
				(
					0: "If possible"
					default: "Donft"
				)
			sub_li = li.SubItems.add str
			/*
			str = case attr.blendMode of
				(
					0: "Auto"
					1: "Opaque"
					2: "Alpha Test"
					3: "Translucent"
					4: "Add"
					5: "Sub"
					default: "Multiply"
				)
			sub_li = li.SubItems.add str
			*/
			append lvItems li
		)
		--print lvItems
		lv_mtl.Items.AddRange lvItems 
		
		--lblSelectedNode.text = str
		if mtls.count > 0 then
		(
			enableUI  true
			loadAttributeToUI (getMtlAttribute mtls[1] false)
		)
		else
		(
			enableUI false
		)
	)
	
	fn mtlUpdateCallback ev nd = 
	(
		format "mtlUpdateCallback %(%), %\n" (classof ev) (ev as string) (nd as string)
		updateSelection()
	)
	
	fn updateNodeCallbacks = 
	(
		local nodes =#()
		nodeCallbacks =#()
		gc()
		for m in mtls do
		(
			local n = refs.dependentNodes m
			if n != undefined do 
			(
				if (appendIfUnique nodes n) do
				(
					local cb = NodeEventCallback mouseUp:true delay:1000 materialOtherEvent:mtlUpdateCallback
					append nodeCallbacks cb
				)
			)
		)
	)

	fn setMtlAttributes =
	(
		--local mtls = getSelMtls selection
		local attr
		for m in mtls do
		(
			attr = getMtlAttribute m true
			--attr.faceCulling = ddlSetFaceCulling.selection - 1
			attr.compress = ddlSetCompress.selection - 1
			--attr.fragmentLighting = chkSetFragmentLighting.checked
			--attr.vertexLighting = chkSetVertexLighting.checked
			--attr.blendMode = ddlSetBlendMode.selection - 1
		)
		updateSelection()
	)
	
	fn selectionCallback = 
	(
		mtls = getSelMtls selection
		--updateNodeCallbacks()
		updateSelection()
	)
	
	fn addCallback = 
	(
		callbacks.addScript #selectionSetChanged "nw4fMaterialRollout.selectionCallback()" id:#nw4fMtlSelectionChange
	)
	fn removeCallback = 
	(
		callbacks.removeScripts id:#nw4fMtlSelectionChange
	)
	
	-- z̑SĂboolFalseȂtrue
	fn isAllBoolFalse bools = 
	(
		if classof bools != Array do return false
		local allOn = true, allOff = false
		for b in bools	do
		(
			allOn = allOn and b
			allOff = allOff or b
		)
		local ret = if allOn or not allOff then true else false
		--format "isAllBoolSame % \n"	ret
		--return ret
		return (not allOff)
	)
	on lv_mtl SelectedIndexChanged e do
	(
		local numItems = lv_mtl.Items.Count
		for i = 0 to (numItems - 1) do
		(
			lv_mtl.Items.Item[i].Selected = false
		)
	)
	on btnSearch pressed  do 
	(
		removeCallback()
		local allMtls = getSelMtls objects
		mtls = #()
		local searchFaceCull, searchFragLight, searchVtxLight, searchCompress, searchBlend
		-- face
		/*
		local fc_front = chkSFC_Front.checked
		local fc_back = chkSFC_Back.checked
		local fc_always = chkSFC_Always.checked
		local fc_never = chkSFC_Never.checked
		searchFaceCull = not (isAllBoolFalse #(fc_front, fc_back,fc_always,fc_never) )
		
		local fl_on = chkSFL_On.checked
		local fl_off = chkSFL_Off.checked
		searchFragLight = not (isAllBoolFalse #(fl_on, fl_off) )

		local vl_on = chkSVL_On.checked
		local vl_off = chkSVL_Off.checked
		searchVtxLight = not (isAllBoolFalse #(vl_on, vl_off) )
		*/
		local comp_on = chkSC_On.checked
		local comp_off = chkSC_Off.checked
		searchCompress = not (isAllBoolFalse #(comp_on, comp_off) )
		/*
		
		local bmAuto = chkBM_Auto.checked
		local bmOpaque = chkBM_Opaque.checked
		local bmAlphaTest = chkBM_AlphaTest.checked
		local bmTranslucent = chkBM_Translucent.checked
		local bmAdd = chkBM_Add.checked
		local bmSub = chkBM_Sub.checked
		local bmMultiply = chkBM_Multiply.checked
		searchBlend = not (isAllBoolFalse #(bmAuto, bmOpaque, bmAlphaTest, bmTranslucent, bmAdd, bmSub, bmMultiply) )
		*/	
		--local isSearchAnd = if rdoSearchType.state == 1 then true else false	
		local isSearchAnd = true
		
		for m in allMtls do
		(
			local compare = true -- ̏Ŕr𑱂邩ǂH
			local ret =false -- ̃}eAr𖞂ǂ
			local attr = getMtlAttribute m true
			/*
			if searchFaceCull and compare do
			(
				ret = case attr.faceCulling of
				(
					0: fc_back
					1: fc_front
					2: fc_always
					3: fc_never
				)
				if ret and (not isSearchAnd) then compare = false -- ̔r𖞂A[hORȂ瑼̔r͕sv
				else if (not ret) and isSearchAnd do compare = false -- ̔r𖞂A[hANDȂ瑼̔r͕sv
			)

			if searchFragLight and compare do
			(
				ret = (attr.fragmentLighting == fl_on) or (attr.fragmentLighting == (not fl_off))
				if ret and (not isSearchAnd) then compare = false
				else if (not ret) and isSearchAnd do compare = false
			)

			if searchVtxLight and compare do
			(
				ret = (attr.vertexLighting == vl_on) or (attr.vertexLighting == (not vl_off))
				if ret and (not isSearchAnd) then compare = false
				else if (not ret) and isSearchAnd do compare = false
			)
			*/

			if searchCompress and compare do
			(
				local isComp = (attr.compress == 0)
				ret = (isComp == comp_on) or (isComp == (not comp_off))
				if ret and (not isSearchAnd) then compare = false
				else if (not ret) and isSearchAnd do compare = false
			)
			/*
			if searchBlend and compare do
			(
				ret = case attr.blendMode of
				(
					0: bmAuto
					1: bmOpaque
					2: bmAlphaTest
					3: bmTranslucent
					4: bmAdd
					5: bmSub
					6: bmMultiply
					default: bmAuto
				)
				if ret and (not isSearchAnd) then compare = false
				else if (not ret) and isSearchAnd do compare = false
			)
			*/
			-- 𖞂΃}eAzɒǉ
			if ret do
			(
				append mtls m
			)
		)
		--print mtls
		clearSelection()
		for m in mtls do
		(
			selectMore (refs.dependentNodes m)
		)
		--updateNodeCallbacks()
		updateSelection()
		addCallback()
	)
	
	
/*
   	on lv_mtl ColumnClick evt do
	(
		if (lv_mtl.ListViewItemSorter.Column != evt.Column) then
		(
			lv_mtl.ListViewItemSorter.Column = evt.Column
			lv_mtl.ListViewItemSorter.Reversed = false
		)
		else
		(
			lv_mtl.ListViewItemSorter.Reversed = (not lv_mtl.ListViewItemSorter.Reversed)
		)
		lv_mtl.Sort()
	)	 
*/	
	--on ddlSetFaceCulling selected i do setMtlAttributes()
	on ddlSetCompress selected i do setMtlAttributes()
	--on chkSetFragmentLighting changed i do setMtlAttributes()
	--on chkSetVertexLighting changed i do setMtlAttributes()
	--on ddlSetBlendMode selected i do setMtlAttributes()

	on nw4fMaterialRollout open  do
	(
		donotRedraw = false
		initListView()
		addCallback()
		--updateSelection()
		selectionCallback()
	)
	on nw4fMaterialRollout close  do
	(
		removeCallback()
	)
	on btnClose pressed  do DestroyDialog nw4fMaterialRollout
)-- mtl rollout

rollout nw4fRenderPriorityRollout "Set Render Priority" width:480 height:400
(
	groupBox grp1 "Selected Material" pos:[8,8] width:464 height:170
	dotNetControl lv_mtl "System.Windows.Forms.ListView" pos:[16,24] width:450 height:150

	groupBox grp2 "Set" pos:[8,187] width:464 height:61
	label lbl6 "Render Priority:" pos:[24,208] width:104 height:16
	radioButtons rdoSetPriorityType "" pos:[128,208] width:87 height:32 labels:#("Don't care", "") columns:1 default:1
	spinner spnSetPriority "" pos:[152,224] width:56 height:16 range:[1,255,1] type:#integer scale:1 enabled:false
	label lbl7 "1(High Priority) - 255(Low Priority)" pos:[224,224] width:240 height:16

	groupBox grp4 "Search" pos:[8,256] width:464 height:104
	label lbl8 "Render Priority:" pos:[24,280] width:104 height:16
	radioButtons rdoSearchPriorityType "" pos:[128,280] width:89 height:48 
			labels:#("Don't care", "Condition", "All Material") columns:1 default:1 \
	dropDownList ddlSearchConditionType "" pos:[208,292] width:96 height:22 default:1 enabled:false \
			items:#("< : under", "<= : below", "= : exactly", ">= : above", "> : over") 
	spinner spnSearchPriority "" pos:[312,294] width:48 height:16 range:[1,255,1] type:#integer scale:1 enabled:false

	button btnSearch "Search" pos:[280,328] width:112 height:24
	button btnClose "Close" pos:[8,368] width:464 height:24
	
	local mtls =#()

	fn getMtlAttribute m create =
	(
		local attrib = m.custAttributes["NW4F Material Custom Attribute"]
		if attrib == undefined then
		(
			--if not create do return undefined 
			attrib = nw4f_mtl_custom_attribute()
			append m.custAttributes attrib
		)
		return attrib
	)

	fn initListView =
	(
		lv_mtl.gridLines = true
		lv_mtl.View = (dotNetClass "System.Windows.Forms.View").Details
		lv_mtl.fullRowSelect = true
		lv_mtl.AutoSize = true
		lv_mtl.MultiSelect = false
		lv_mtl.LabelEdit = true
		lv_mtl.AllowColumnReorder = true
		lv_mtl.Columns.add "Render Priority" 
		lv_mtl.Columns.add "Material Name" 
		lv_mtl.Columns.Item[0].DisplayIndex = 1
		lv_mtl.Columns.Item[1].DisplayIndex = 0
		--lv_mtl.sorting = (dotNetClass "System.Windows.Forms.SortOrder").Ascending
		lv_mtl.AutoResizeColumns ((dotNetClass "System.Windows.Forms.ColumnHeaderAutoResizeStyle").HeaderSize)
		
	)
	
	fn getSelMtls sel = 
	(
		local smtls = #()
		for n in sel do
		(
			local mtl = n.material
			if mtl != undefined do
			(
				appendIfUnique smtls mtl
				if(classOf mtl == Multimaterial) do
				(
					for submtl in mtl.materialList do
					(
						appendIfUnique smtls submtl
					)
				)
			)
		)
		return smtls
	)

	fn updateSelection =
	(
		lv_mtl.Items.Clear()

		local str = ""
		--local mtls = getSelMtls selection
		
		local lvItems =#()
		for m in mtls do
		(
			local attr = getMtlAttribute m true
			local val = 0
			if attr.renderPriorityType == 1 do
			(
				val = attr.renderPriority
			)
			local li = dotNetObject "System.Windows.Forms.ListViewItem" (val as string)
			local sub_li = li.SubItems.add m.name
			append lvItems li
		)
		lv_mtl.Items.AddRange lvItems 
	)
	
	fn setMtlAttributes =
	(
		--local mtls = getSelMtls selection
		local attr
		undo "Edit render priority" on
		(
			spnSetPriority.enabled = (rdoSetPriorityType.state == 2)
			for m in mtls do
			(
				attr = getMtlAttribute m true
				local val = 0
				if rdoSetPriorityType.state == 1 then
				(
					attr.renderPriorityType = 0
				)
				else
				(
					attr.renderPriorityType = 1
					attr.renderPriority = spnSetPriority.value
				)
			)
		)
		updateSelection()
	)
	
	fn selectionCallback = 
	(
		mtls = getSelMtls selection
		updateSelection()
	)
	
	fn addCallback = 
	(
		callbacks.addScript #selectionSetChanged "nw4fRenderPriorityRollout.selectionCallback()" \
				id:#nw4fRenderPrioritySelectionChange
	)
	fn removeCallback = 
	(
		callbacks.removeScripts id:#nw4fRenderPrioritySelectionChange
	)
	
	on btnSearch pressed  do 
	(
		removeCallback()
		local allMtls = getSelMtls objects
		mtls = #()
	
		for m in allMtls do
		(
			local attr = getMtlAttribute m true
			local ret= false
			
			case rdoSearchPriorityType.state of
			(
				1: ( -- Don't care
					if attr.renderPriorityType == 0 do
					(
						ret = true
					)
				)
				2: ( -- condition
					if attr.renderPriorityType == 1 do
					(
						local v = spnSearchPriority.value
						case ddlSearchConditionType.selection of
						(
							1: ( -- under
								ret = (attr.renderPriority < v)
							)
							2: ( -- below
								ret = (attr.renderPriority <= v)
							)
							3: ( -- exactly
								ret = (attr.renderPriority == v)
							)
							4: ( -- above
								ret = (attr.renderPriority >= v)
							)
							5: ( -- over
								ret = (attr.renderPriority > v)
							)
						)
					)
				)
				default: ret = true
			)
			
			-- 𖞂΃}eAzɒǉ
			if ret do
			(
				append mtls m
			)
		)

		clearSelection()
		for m in mtls do
		(
			selectMore (refs.dependentNodes m)
		)

		updateSelection()
		addCallback()
	)
	
	on lv_mtl AfterLabelEdit ev do
	(
		local str = ev.Label
		local cancel = true
		if str != undefined do 
		(
			local v = str as Integer
			if v != undefined  do
			(
				if (1 <= v) and (v <= 255) do
				(
					local subItem = lv_mtl.Items.item[ev.Item].subitems
					local eMtl = subItem.Item[1].Text
					--format "set priority \"%\" = %\n" eMtl v
					local attr = undefined
					for m in sceneMaterials while attr == undefined do
					(
						if m.name == eMtl then
						(
							attr = getMtlAttribute m true
						)
						else if(classOf m == Multimaterial) do
						(
							for submtl in m.materialList while attr == undefined do
							(
								if submtl.name == eMtl then
								(
									attr = getMtlAttribute submtl true
								)
							)
						)
					)
					
					if attr != undefined do
					(
						attr.renderPriorityType = if (v == 0) then 0 else 1
						attr.renderPriority = v
						cancel = false
					)
				)
			)
		)
		ev.CancelEdit = cancel
	)
	
	on rdoSetPriorityType changed i do setMtlAttributes()
	on spnSetPriority changed i do setMtlAttributes()
	
	on rdoSearchPriorityType changed i do 
	(
		ddlSearchConditionType.enabled = (i == 2)
		spnSearchPriority.enabled = (i == 2)
	)


	on nw4fRenderPriorityRollout lbuttondown mp do
	(
		--print mp
	)


	on nw4fRenderPriorityRollout open  do
	(
		mtls = #()
		--donotRedraw = false
		initListView()
		addCallback()
		--updateSelection()
		selectionCallback()
	)
	on nw4fRenderPriorityRollout close  do
	(
		removeCallback()
	)
	on btnClose pressed  do DestroyDialog nw4fRenderPriorityRollout
)-- priority rollout

rcMenu nw4fMtlUserDataMenu
(
	subMenu "Help" 
	(
		menuItem mi_Help "Help On Set Material User Data..."
	)
	on mi_Help picked do nintendoExportRollout.showHelp @"html\NW4F_AddMaterialAttribute.html"
)
rollout nw4fMtlUserDataRollout "Set Material User Data" width:480 
(
	group "Selected Material"
	(
		label lblMtl
	)
	group "Edit Data"
	(
		button btnUp "Move Up" across:5
		button btnDown "Move Down" 
		button btnAdd "Add..."
		button btnDelete "Delete"
		button btnEdit "Edit..."
		dotNetControl lv_data "System.Windows.Forms.ListView" width:450 height:164
	)
	checkbox chkDisplayHex "Display integer value in hexadecimals"
	button btnClose "Close" width:474 height:24
		
	local utils = NintendoExportUtilities()
	local dataset = undefined
	local mtl = undefined
	
	fn getMtlAttribute m create =
	(
		local attrib = m.custAttributes["NW4F Material Custom Attribute"]
		if attrib == undefined then
		(
			if not create do return undefined
			attrib = nw4f_mtl_custom_attribute()
			append m.custAttributes attrib
		)
		return attrib
	)
	
	fn initListView =
	(
		lv_data.gridLines = true
		lv_data.View = (dotNetClass "System.Windows.Forms.View").Details
		lv_data.fullRowSelect = true
		lv_data.AutoSize = true
		lv_data.MultiSelect = false
		lv_data.Columns.add " Name   "
		lv_data.Columns.add " Type   "
		lv_data.Columns.add " Size"
		lv_data.Columns.add " Value"
		lv_data.AutoResizeColumns ((dotNetClass "System.Windows.Forms.ColumnHeaderAutoResizeStyle").HeaderSize)
	)
	
	fn saveData =
	(
		-- 1IꂽƂ
		if superClassOf mtl != material do return false
			
		local attr = getMtlAttribute mtl true
		if attr != undefined do
		(
			attr.userSettings = dataset.toString()
		)
	)
	
	fn updateSelection =
	(
		lv_data.Items.Clear()
		dataset = nw4f_userDataSet()
		
		local lvItems =#()
		
		-- 1IꂽƂ
		if superClassOf mtl == material then
		(
			lblMtl.text = mtl.name
			btnUp.enabled = true
			btnDown.enabled  = true
			btnAdd.enabled  = true
			btnDelete.enabled  = true
			btnEdit.enabled  = true
		)
		else
		(
			lblNode.text = ""
			btnUp.enabled = false
			btnDown.enabled  = false
			btnAdd.enabled  = false
			btnDelete.enabled  = false
			btnEdit.enabled  = false
			return ()
		)
		
		local attr = getMtlAttribute mtl false
		if attr != undefined then --Agr[gꍇ
		(
			local str = attr.userSettings
			if (classof str) == String do
			(
				local ret = dataset.fromString str
				if ret do
				(
					for i = 1 to dataset.list.count do
					(
						local data = dataset.list[i]
						local li = dotNetObject "System.Windows.Forms.ListViewItem" data.dataname
						local sub_li 
						sub_li = li.SubItems.add (data.type as String)
						sub_li = li.SubItems.add ((data.valueCount()) as string)
						sub_li = li.SubItems.add ((data.valueToString oneline:true inHex:utils.displayIntegerInHex) as string)
						append lvItems li
					)
				)
			)
		)
		lv_data.Items.AddRange lvItems 
	)

	fn EditData data add = 
	(
		nw4fEditUserDataRollout_ValueSet = dataset
		nw4fEditUserDataRollout_Value = data
		CreateDialog  nw4fEditUserDataRollout modal:true
		if nw4fEditUserDataRollout_Value != undefined do
		(
			if add do dataset.appendData nw4fEditUserDataRollout_Value
			saveData()
			updateSelection()
		)
	)
	
	on nw4fMtlUserDataRollout open  do
	(
		initListView()
		mtl = medit.GetCurMtl()
		utils.loadSettingConfig()
		chkDisplayHex.checked = utils.displayIntegerInHex
		updateSelection()
	)
	on nw4fMtlUserDataRollout close  do
	(
	)
	
	on chkDisplayHex changed val do
	(
		utils.displayIntegerInHex = val
		utils.saveSettingConfig()
		updateSelection()
	)
	
	on btnUp pressed do 
	(
		if lv_data.SelectedIndices.Count > 0 do
		(
			local id = lv_data.SelectedIndices.Item[0]
			local maxid = id + 1
			if id > 0 do
			(
				local tmp = dataset.list[maxid]
				deleteItem dataset.list (maxid)
				insertItem tmp dataset.list (maxid - 1)
				saveData()
				updateSelection()
				lv_data.Items.Item[id-1].Selected = true
			)
			lv_data.Focus()
		)
	)
	on btnDown pressed do 
	(
		if lv_data.SelectedIndices.Count > 0 do
		(
			local id = lv_data.SelectedIndices.Item[0]
			local maxid = id + 1
			if maxid < dataset.list.count do
			(
				local tmp = dataset.list[maxid]
				deleteItem dataset.list (maxid)
				insertItem tmp dataset.list (maxid + 1)
				saveData()
				updateSelection()
				lv_data.Items.Item[id+1].Selected = true
			)
			lv_data.Focus()
		)
	)

	on btnDelete pressed do 
	(
		if lv_data.SelectedIndices.Count > 0 do
		(
			local id = lv_data.SelectedIndices.Item[0]
			local maxid = id + 1
			(
				deleteItem dataset.list (maxid)
				saveData()
				updateSelection()
			)
			lv_data.Focus()
		)
	)
	
	on btnAdd pressed do 
	(
		if (classof dataset) == nw4f_userDataSet do
		(
			editData (nw4f_userData()) true
		)
	)
	
	on btnEdit pressed do 
	(
		if (classof dataset) == nw4f_userDataSet do
		(
			if lv_data.SelectedIndices.Count > 0 do
			(
				local id = lv_data.SelectedIndices.Item[0]
				local maxid = id + 1
				editData (dataset.list[maxid]) false
			)
		)
	)
	
	on btnClose pressed  do DestroyDialog nw4fMtlUserDataRollout
		
)-- Set Mtl User Data

rcMenu nw4fSamplerMenu
(
	subMenu "Help" 
	(
		menuItem mi_Help "Help On Set Sampler Attribute..."
	)
	on mi_Help picked do nintendoExportRollout.showHelp @"html\NW4F_SetSamplerAttr.html"
)
rollout nw4fSamplerRollout "Set Sampler Attribute" width:480 --height:550
(
	group"Selected Material"
	(
	dotNetControl lv_mtl "System.Windows.Forms.ListView" pos:[16,24] width:450 height:150
	)
	--
	group "Set"
	(
		editText editName 	"  Name" width:290 --across:3
		editText editHint 	"  Hint  " width:290 across:3
		label lblSet1 "" 
		button btnSetNameHint "  Set  "	height:40 offset:[0,-22] align:#left
	)
	--
	group "Search"
	(
		editText editSearchName "  Name" 	text:"*" width:290 across:3
		label lblSearch1 "" 
		button btnSearchName "  Search  "		align:#left
		editText editSearchHint 	"  Hint  " text:"*" width:290 across:3
		label lblSearch2 "" 
		button btnSearchHint "  Search  " 		align:#left
	)
	
	button btnClose "Close" width:464 height:24

	local donotRedraw
	local mtls = #()
	local textures = #()
	local nodeCallbacks =#()
	
	fn initListView =
	(
		lv_mtl.gridLines = true
		lv_mtl.View = (dotNetClass "System.Windows.Forms.View").Details
		lv_mtl.fullRowSelect = true
		lv_mtl.AutoSize = true
		lv_mtl.MultiSelect = true
		lv_mtl.HideSelection = false
		lv_mtl.Columns.add "Material Name  " 
		lv_mtl.Columns.add "Texture Name ( File Name ) " 
		lv_mtl.Columns.add "Sampler Name"
		lv_mtl.Columns.add "Sampler Hint  "
		--lv_mtl.Columns.add "BlendMode"
		--lv_mtl.sorting = (dotNetClass "System.Windows.Forms.SortOrder").Ascending
		lv_mtl.AutoResizeColumns ((dotNetClass "System.Windows.Forms.ColumnHeaderAutoResizeStyle").HeaderSize)
	)

	fn getSamplerAttribute tex create =
	(
		local attrib = tex.custAttributes["Nw4f Sampler Custom Attribute"]
		if attrib == undefined then
		(
			if not create do return undefined 
			attrib = Nw4f_Sampler_Custom_Attribute()
			append tex.custAttributes attrib
		)
		return attrib
	)
	fn nameComp v1 v2 = 
	(
		m1 = v1.name
		m2 = v2.name
		if m1 < m2 then -1 else if m1 > m2 then 1 else 0 
	)

	fn getSelMtls sel = 
	(
		local smtls = #()
		for n in sel do
		(
			local mtl = n.material
			if mtl != undefined do
			(
				if(classOf mtl == Multimaterial) then
				(
					for submtl in mtl.materialList do
					(
						appendIfUnique smtls submtl
					)
				)
				else
				(
					appendIfUnique smtls mtl
				)
			)
		)
		qsort smtls nameComp
		return smtls
	)
	
	fn enableUI flag =
	(
		editName.enabled = flag
		editHint.enabled = flag
		btnSetNameHint.enabled = flag
	)
	
	fn loadAttributeToUI attr =
	(
		if (classof attr) != nw4f_mtl_custom_attribute do return()
		
		--ddlSetFaceCulling.selection = attr.faceCulling + 1
		ddlSetCompress.selection = attr.compress + 1
		--chkSetFragmentLighting.checked = attr.fragmentLighting
		--chkSetVertexLighting.checked = attr.vertexLighting
		--ddlSetBlendMode.selection = attr.blendMode + 1
	)
	
	-- getTextures ̓}eA܂̓eNX`Ɋ܂܂Tu}bv
	-- 2zŕԂ
	-- ex. #(#(tex1, "mtl1"), #(tex2, "mtl1"),#(tex3, "mtl2")....)
	fn getTextures m holderName =
	(
		local subTextures = #()
		
		local numMaps = getNumSubTexmaps m
		for i = 1 to numMaps do
		(
			local t = getSubTexmap m i
			if t != undefined do
			(
				-- maprbg}bvȂǉAȊO̓TueNX`ǉ
				local tclass = classof t
				if tclass == BitmapTexture then
				(
					appendIfUnique subTextures #(t, holderName)
				)
				else if (tclass == CompositeTextureMap) or (tclass == Normal_Bump) do
				(
					subTextures = subTextures + (getTextures t holderName)
				)
			)
		)
		
		return subTextures
	)
	
	fn drawListView = 
	(
		lv_mtl.Items.Clear()
		local lvItems =#()
		for t in textures do
		(
			local tex = t[1]
			local mtlname = t[2]
			local attr = getSamplerAttribute tex false

			local li = dotNetObject "System.Windows.Forms.ListViewItem" mtlname
			local sub_li 
			
			--sub_li = li.SubItems.add mtlname
			if (classof tex) == BitmapTexture then
			(
				local texfilename = if tex.filename == undefined then "" else (filenameFromPath tex.filename)
				sub_li = li.SubItems.add (tex.name + "(" + texfilename + ")")
			)
			else
			(
				sub_li = li.SubItems.add tex.name
			)
			
			if attr == undefined then
			(
				sub_li = li.SubItems.add ""
				sub_li = li.SubItems.add ""
			)
			else
			(
				sub_li = li.SubItems.add attr.samplerName
				sub_li = li.SubItems.add attr.samplerHint
			)
			
			append lvItems li
		)
		--print lvItems
		lv_mtl.Items.AddRange lvItems 
		
		--lblSelectedNode.text = str
		/*
		if textures.count > 0 then
		(
			enableUI  true
			--loadAttributeToUI (getMtlAttribute mtls[1] false)
		)
		else
		*/
		(
			enableUI false
		)
	)
	
	-- smtls̃eNX`񋓂
	fn getMtlTextures smtls = 
	(
		local texs = #()
		-- Iꂽm[h̃}eAeNX`
		for m in smtls do
		(
			texs = texs + (getTextures m m.name)
		)
		
		(
			-- eNX`CX^Xւ̎QƂ͈ɂ
			local texIdx = 1
			while texIdx < texs.count do
			(
				--print texIdx
				for i = texs.count to (texIdx + 1) by -1 do
				(
					--print i
					--print subtex
					if texs[texIdx][1] == texs[i][1] do
					(
						texs = deleteItem texs i
					)
					--print subtex
				)
				
				texIdx += 1
			)
		)
		return texs
	)

	fn updateSelection =
	(
		if donotRedraw do return()
		--print "updateSelection"
		--print mtls
		textures = getMtlTextures mtls

		drawListView()
	)
	
	fn mtlUpdateCallback ev nd = 
	(
		format "mtlUpdateCallback %(%), %\n" (classof ev) (ev as string) (nd as string)
		updateSelection()
	)
	
	fn updateNodeCallbacks = 
	(
		local nodes =#()
		nodeCallbacks =#()
		gc()
		for m in mtls do
		(
			local n = refs.dependentNodes m
			if n != undefined do 
			(
				if (appendIfUnique nodes n) do
				(
					local cb = NodeEventCallback mouseUp:true delay:1000 materialOtherEvent:mtlUpdateCallback
					append nodeCallbacks cb
				)
			)
		)
	)

	fn selectionCallback = 
	(
		mtls = getSelMtls selection
		--updateNodeCallbacks()
		updateSelection()
	)
	
	fn addCallback = 
	(
		callbacks.addScript #selectionSetChanged "nw4fSamplerRollout.selectionCallback()" id:#nw4fSamplerSelectionChange
	)
	fn removeCallback = 
	(
		callbacks.removeScripts id:#nw4fSamplerSelectionChange
	)
	
	on lv_mtl SelectedIndexChanged e do
	(
		if lv_mtl.SelectedIndices.Count > 0 then
		(
			enableUI true
			local id = lv_mtl.SelectedIndices.Item[0]
			local maxid = id + 1
			if maxid > 0 and textures[maxid] != undefined do
			(
				local tex = textures[maxid][1]
				local attr = getSamplerAttribute tex false
				if attr == undefined then
				(
					editName.text = ""
					editHint.text = ""
				)
				else
				(
					editName.text = attr.samplerName
					editHint.text  = attr.samplerHint
				)
				editName.changed editName.text
			)
		)
		else
		(
			enableUI false
		)
	)
	
	on editName changed val do
	(
		--editHint.enabled = btnSetNameHint.enabled = (val.count > 0)
		
		if val.count > 0 then
		(
			editHint.enabled = true
		)
		else
		(
			editHint.text = ""
			editHint.enabled = false
		)
	)
	
	on btnSetNameHint pressed do
	(
		if editName.text.count == 0 do editHint.text = ""
		local selCount = lv_mtl.SelectedIndices.Count 
		for i = 0 to (selCount - 1) do
		(
			local id = lv_mtl.SelectedIndices.Item[i]
			local maxid = id + 1
			local tex = textures[maxid][1]
			if tex != undefined do
			(
				local attr = getSamplerAttribute tex true
				if attr != undefined do
				(
					attr.samplerName = editName.text
					attr.samplerHint = editHint.text  
				)
			)
		)
		drawListView()
	)
	
	fn searchTexAttrAndSet searchText targetType = 
	(
		local smtls = getSelMtls objects
		local allTex = getMtlTextures smtls
		textures = #()
		local isWild = (searchText == "*")
		
		for t in allTex do
		(
			local tex = t[1]
			local mtlname = t[2]
			local attr = getSamplerAttribute tex false
			-- Agr[gȂĂXgOhh̏ꍇ̓qbg
			if attr == undefined then
			(
				if searchText.count == 0 do
				(
					append textures #(tex, mtlname)
				)
			)
			else
			(
				local target = if targetType == #name then attr.samplerName else attr.samplerHint
				
				if searchText.count == 0 then
				(
					if target.count == 0 do
					(
						append textures #(tex, mtlname)
					)
				)
				else
				(
					-- h*hŉ͂Ă΃qbg
					if isWild and target.count > 0 then
					(
						append textures #(tex, mtlname)
					)
					else if (findstring target searchText) != undefined then
					(
						append textures #(tex, mtlname)
					)
				)
			)
		)
	)
	
	on btnSearchName pressed  do 
	(
		removeCallback()
		searchTexAttrAndSet editSearchName.text #name
		addCallback()
		drawListView()
	)
	
	on btnSearchHint pressed  do 
	(
		removeCallback()
		searchTexAttrAndSet editSearchHint.text #hint
		addCallback()
		drawListView()
	)
	
	
	on nw4fSamplerRollout open  do
	(
		donotRedraw = false
		initListView()
		addCallback()
		--updateSelection()
		selectionCallback()
	)
	on nw4fSamplerRollout close  do
	(
		removeCallback()
	)
	on btnClose pressed  do DestroyDialog nw4fSamplerRollout
)-- Set Sampler Attribute rollout


-- Material editor menu
macroScript AddMaterialAttribute category:"Nintendo"
(
	local mtl = medit.GetCurMtl()
	if (mtl != undefined) and (superClassOf mtl == material) do
	(
		nw4fMaterialRollout.getMtlAttribute mtl true
	)
)

macroScript DeleteMaterialAttribute category:"Nintendo"
(
	local mtl = medit.GetCurMtl()
	if (mtl != undefined) and (superClassOf mtl == material) do
	(
		deleteItem mtl.custAttributes "NW4F Material Custom Attribute"
	)
)

macroScript SetMaterialUserData category:"Nintendo"
(
	local mtl = medit.GetCurMtl()
	if (mtl != undefined) and (superClassOf mtl == material) do
	(
		CreateDialog  nw4fMtlUserDataRollout menu:nw4fMtlUserDataMenu modal:true
	)
)

fn getNw4fMtlMenu =
(
	local mtlMenuBar = NintendoExport.GetMtlEditorMenu()
	-- NW4F j[폜
	for i = mtlMenuBar.numitems() to 1 by -1 do 
	(
		local mi = mtlMenuBar.getItem i
		if ( (mi.getTitle()) == "NW4F" ) do
		(
			mtlMenuBar.removeItemByPosition i
		)
	)

	for i = 1 to mtlMenuBar.numitems() do 
	(
		local mi = mtlMenuBar.getItem i
		if ( (mi.getTitle()) == "Nintendo" ) do
		(
			return mi
		)
	)

	-- Nintendo j[o^
	local subMenu = menuMan.createMenu "Nintendo"
	local subMenuItem = menuMan.createSubMenuItem "Test Menu" subMenu
	-- Tuj[Ōォ 2 Ԗڂ̃Xbgɒǉ܂B
	mtlMenuBar.addItem subMenuItem -1
	return subMenuItem
)

fn resetMtlMenuActions mi =
(
	local menu = mi.getSubMenu()
	-- ܂o^ς݂̃Tuj[ACe폜
	while (menu.numItems() > 0) do
	(
		menu.removeItemByPosition 1
	)
	
	local dialogItem 

	dialogItem = menuMan.createActionItem "AddMaterialAttribute" "Nintendo"
	dialogItem.setTitle "Add Material Attribute"
	dialogItem.setUseCustomTitle true
	menu.addItem dialogItem -1

	dialogItem = menuMan.createActionItem "DeleteMaterialAttribute" "Nintendo"
	dialogItem.setTitle "Delete Material Attribute"
	dialogItem.setUseCustomTitle true
	menu.addItem dialogItem -1
	
	dialogItem = menuMan.createSeparatorItem()
	menu.addItem dialogItem -1
	
	dialogItem = menuMan.createActionItem "SetMaterialUserData" "Nintendo"
	dialogItem.setTitle "Set Material User Data"
	dialogItem.setUseCustomTitle true
	menu.addItem dialogItem -1
)
