﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <util/UtilBuffer.h>

namespace nw { namespace g3d { namespace tool {
namespace util {

bool Buffer::LoadFile(const wchar_t* path, size_t alignment)
{
    std::ifstream ifs(path, std::ios_base::binary | std::ios_base::in);
    if (!ifs.is_open())
    {
        return false;
    }

    // get file size
    ifs.seekg(0, std::ios_base::end);
    size_t size = static_cast<size_t>(ifs.tellg());
    ifs.seekg(0, std::ios_base::beg);

    // テキストの場合に備えてポインタサイズ分はゼロフィルする。
    size_t padding = sizeof(void*);
    size_t bufSize = size + padding;

    void* memory = _aligned_malloc(bufSize, alignment);
    std::shared_ptr<void> pData(memory, _aligned_free);
    ifs.read(static_cast<char*>(pData.get()), bufSize);
    memset(static_cast<char*>(pData.get()) + size, 0, padding);

    // 成功したので登録する。
    m_pData.swap(pData);
    m_Size = size;

    ifs.close();
    return true;
}

void Buffer::Alloc(size_t size, size_t alignment)
{
    if (size == 0)
    {
        Reset();
        return;
    }

    m_pData.reset(_aligned_malloc(size, alignment), _aligned_free);
    m_Size = size;
}

bool Buffer::SaveFile(const wchar_t* path)
{
    FILE* file;
    errno_t err = _wfopen_s(&file, path, L"wb");
    if (err)
    {
        return false;
    }
    struct Closer
    {
        FILE* file;
        Closer(FILE* file) : file(file) {}
        ~Closer()
        {
            fclose(file);
        }
    } closer(file);

    fwrite(m_pData.get(), m_Size, 1, file);
    return true;
}

} // namespace util

} // namespace tool
} // namespace g3d
} // namespace nw
