﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <util/types.h>
#include <util/UtilXMLParser.h>
#include <util/UtilError.h>
#include <util/UtilErrorCode.h>

namespace nw { namespace g3d { namespace tool {
namespace util {

template <typename T>
class Optional
{
public:
    Optional() : value(), exist(false) {}
    Optional(T value) : value(value), exist(true) {}

    T* operator->() { return exist ? &value : nullptr; }
    const T* operator->() const { return exist ? &value : nullptr; }

    operator bool () const { return exist; }

    void Validate() { exist = true; }
    void Invalidate() { exist = false; value = T(); }

    T& Get() { return value; }
    const T& Get() const { return value; }

private:
    T value;
    bool exist;
};

template <typename T, int identifier>
class Attribute
{
public:
    Attribute() : value() {}
    Attribute(T value) : value(value) {}

    T* operator->() { return &value; }
    const T* operator->() const { return &value; }

    static const int id = identifier;
    T value;
};

} // namespace util

#define S11N_DEFINE_ID(name) const ::util::LiteralStr id_##name = {#name, strlen(#name)}
#define S11N_DEFINE_ENUM_ID(name) {#name, strlen(#name)}
#define S11N_DEFINE_ENUM_ID_TABLE(class_name, enum_name, ...)                                      \
    const ::util::LiteralStr class_name::tbl_##enum_name[] = {                                     \
        __VA_ARGS__,                                                                               \
    };                                                                                             \
    static_assert(sizeof(class_name::tbl_##enum_name) ==                                           \
        sizeof(::util::LiteralStr) * class_name::num_##enum_name,                                  \
        "Invalid table size.")                                                                     \


} // namespace tool
} // namespace g3d
} // namespace nw
