﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <Windows.h>
#include <eh.h>

#pragma warning(push)
#pragma warning(disable:4091)
#include <dbghelp.h>
#pragma warning(pop)

namespace nw { namespace g3d { namespace tool {
namespace util {

#define Print(stream, format, ...) PrintImpl(stream, L##format, __VA_ARGS__)
#define PrintLn(stream, format, ...) PrintLnImpl(stream, L##format, __VA_ARGS__)

void PrintImpl(FILE* stream, const wchar_t* format, ...);
void PrintLnImpl(FILE* stream, const wchar_t* format, ...);

} // namespace util

} // namespace tool
} // namespace g3d
} // namespace nw
