﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <windows.h>
#include <GL/gl.h>

namespace nw { namespace g3d { namespace tool {
namespace util {

//! @brief GL を使うためのシングルトンの偽装コンテキスト
class GLContext
{
public:
    static GLContext* Instance()
    {
        if (m_Instance == nullptr)
        {
            m_Instance = new GLContext();
        }

        return m_Instance;
    }

    static void DeleteInstance()
    {
        if (m_Instance != nullptr)
        {
            delete m_Instance;
            m_Instance = nullptr;
        }
    }

    void Init();
    void Delete();

    void MakeCurrent();

private:
    GLContext()
        : m_IsInitialized(false)
        , m_HWnd(nullptr)
        , m_Hdc(nullptr)
        , m_Hglrc(nullptr) {}

    GLContext(const GLContext&) {}

    static GLContext* m_Instance;

    bool m_IsInitialized;
    HWND m_HWnd;
    HDC m_Hdc;
    HGLRC m_Hglrc;
};

} // namespace util

} // namespace tool
} // namespace g3d
} // namespace nw
