﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <util/types.h>

namespace nw { namespace g3d { namespace tool {
namespace util {

//---------------------------------------------------------------------------
//! @brief        ビットフィールドの指定のマスクのビットが全て真かチェックします。
//!
//! @tparam       flags   現在のビットフィールドです。
//! @tparam       mask    チェックに用いるマスクです。
//---------------------------------------------------------------------------
template<typename TFlags, typename TMask>
bool CheckFlag(TFlags flags, TMask mask)
{
    return (flags & static_cast<TFlags>(mask)) == static_cast<TFlags>(mask);
}

//---------------------------------------------------------------------------
//! @brief        ビットフィールドの指定のマスクのビットのいずれかが真かチェックします。
//!
//! @tparam       flags   現在のビットフィールドです。
//! @tparam       mask    チェックに用いるマスクです。
//---------------------------------------------------------------------------
template<typename TFlags, typename TMask>
bool CheckFlagOr(TFlags flags, TMask mask)
{
    return (flags & static_cast<TFlags>(mask)) != 0;
}

//---------------------------------------------------------------------------
//! @brief        ビットフィールドの指定のビット値を真にします。
//!
//! @tparam       flags   現在のビットフィールドです。
//! @tparam       value   真にしたいビット値です。
//---------------------------------------------------------------------------
template<typename TFlags, typename TValue>
TFlags EnableFlag(TFlags flags, TValue value)
{
    return flags | static_cast<TFlags>(value);
}

//---------------------------------------------------------------------------
//! @brief        ビットフィールドの指定のビット値を偽にします。
//!
//! @tparam       flags   現在のビットフィールドです。
//! @tparam       value   偽にしたいビット値です。
//---------------------------------------------------------------------------
template<typename TFlags, typename TValue>
TFlags DisableFlag(TFlags flags, TValue value)
{
    return flags & ~(static_cast<TFlags>(value));
}

} // namespace util

} // namespace tool
} // namespace g3d
} // namespace nw
