﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nw { namespace g3d { namespace tool {
class CmdOption
{
public:
    explicit CmdOption(const wchar_t* arg);

    static int FindIndex(const std::vector<CmdOption>& options, const wchar_t* name);

    std::wstring name;
    std::wstring value;
};

class CmdInput
{
public:
    explicit CmdInput(const wchar_t* path);

    std::wstring fullpath;
    std::wstring fname;
    std::wstring ext;

    std::vector<CmdOption> options;
};

class CmdArgs
{
public:
    CmdArgs(int argc, const wchar_t* argv[]);

    std::wstring cmd;
    std::vector<CmdOption> options;
    std::vector<CmdInput> inputs;
};

} // namespace tool
} // namespace g3d
} // namespace nw
