﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <g3dif/ShaderVariation.h>
#include <algorithm>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

//--------------------------------------------------------------------------------------------------

void elem_option::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        id << pElem;
        choice << pElem;
    }
    CATCH_THROW_XML_ERROR()
}


//--------------------------------------------------------------------------------------------------

void elem_shader_program::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        option_array << pElem->Child(elem_option::IdArray());
    }
    CATCH_THROW_XML_ERROR()
}

//--------------------------------------------------------------------------------------------------

void elem_target_shader::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        shading_model_name << pElem;
        shader_program_array << pElem->Child(elem_shader_program::IdArray());
    }
    CATCH_THROW_XML_ERROR()
}

//--------------------------------------------------------------------------------------------------

void elem_shader_variation_info::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        shader_archive << pElem;
    }
    CATCH_THROW_XML_ERROR()
}

//--------------------------------------------------------------------------------------------------

void elem_shader_variation::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        version << pElem;
        shader_variation_info << pElem->Child(elem_shader_variation_info::Id());
        target_shader_array << pElem->Child(elem_target_shader::IdArray());
    }
    CATCH_THROW_XML_ERROR()
}

//--------------------------------------------------------------------------------------------------

void elem_shader_variation::PostProcess()
{
    try
    {
        for (auto el_target_shader = target_shader_array.begin(); el_target_shader != target_shader_array.end(); ++el_target_shader)
        {
            for (auto el_shader_program = el_target_shader->shader_program_array.begin(); el_shader_program != el_target_shader->shader_program_array.end(); ++el_shader_program)
            {
                for (auto el_option = el_shader_program->option_array.begin(); el_option != el_shader_program->option_array.end(); ++el_option)
                {
                    ExpandChoice(el_option->choiceArray, el_option->choice.value);
                }
            }
        }
    }
    CATCH_THROW_XML_ERROR()
}

void elem_shader_variation::CheckData(int /*flag*/)
{
    for (auto el_target_shader = target_shader_array.cbegin();
        el_target_shader != target_shader_array.cend();
        ++el_target_shader)
    {
        if (el_target_shader->shading_model_name.value.empty())
        {
            THROW_ERROR(ERRCODE_XML_INVALID_SHADING_MODEL_NAME, "shading_model_name should not be empty.");
        }

        const std::string& shading_model_name = el_target_shader->shading_model_name.value;
        for (auto find_target = el_target_shader + 1;
            find_target != target_shader_array.cend();
            ++find_target)
        {
            if (shading_model_name == find_target->shading_model_name.value)
            {
                THROW_ERROR(ERRCODE_XML_INVALID_SHADING_MODEL_NAME, "target_shader should have a unique shading_model_name.");
            }
        }
    }
}

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
