﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>
#include <g3dif/Stream.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

class elem_user_int
{
public:

    elem_user_int() : count(0), textData(nullptr), rawdata() {}

    G3DIF_DEFINE_ELEM(user_int);

    G3DIF_DEFINE_ATTRIB(int, count);

    const char* textData;
    std::shared_ptr<void> rawdata;
};

class elem_user_float
{
public:

    elem_user_float() : count(0), stream_index(0), rawdata() {}

    G3DIF_DEFINE_ELEM(user_float);

    G3DIF_DEFINE_ATTRIB(int, count);
    G3DIF_DEFINE_ATTRIB(int, stream_index);

    const char* textData;
    std::shared_ptr<void> rawdata;
};

class elem_string
{
public:
    elem_string() : stream() {}
    G3DIF_DEFINE_ELEM(string);

    const char* textData;
    std::string stream;
};

class elem_user_string
{
public:

    elem_user_string() : count(0), string_array() {}
    G3DIF_DEFINE_ELEM(user_string);

    G3DIF_DEFINE_ATTRIB(int, count);

    std::vector<elem_string> string_array;
};

class elem_wstring
{
public:
    elem_wstring() : stream() {}
    G3DIF_DEFINE_ELEM(wstring);

    const char* textData;
    std::wstring stream;
};

class elem_user_wstring
{
public:

    elem_user_wstring() :  count(0), wstring_array() {}
    G3DIF_DEFINE_ELEM(user_wstring);

    G3DIF_DEFINE_ATTRIB(int, count);

    std::vector<elem_wstring> wstring_array;
};

class elem_user_stream
{
public:

    elem_user_stream() :  size(0), stream_index(0) {}
    G3DIF_DEFINE_ELEM(user_stream);

    G3DIF_DEFINE_ATTRIB(int, size);
    G3DIF_DEFINE_ATTRIB(int, stream_index);

    DataStream stream;
};

class elem_user_data
{
public:
    elem_user_data()
        : name()
        , user_int()
        , user_float()
        , user_string()
        , user_wstring()
        , user_stream()
    {}

    G3DIF_DEFINE_ELEM_ARRAY(user_data);
    void PostProcess(std::vector<elem_stream>& stream_array);
    void PostBinaryProcess(StreamArray& streamArray);

    G3DIF_DEFINE_ATTRIB(std::string, name);

    StreamType type;

    util::Optional<elem_user_int> user_int;
    util::Optional<elem_user_float> user_float;
    util::Optional<elem_user_string> user_string;
    util::Optional<elem_user_wstring> user_wstring;
    util::Optional<elem_user_stream> user_stream;
};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
