﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>
#include <g3dif/AnimCurve.h>
#include <g3dif/UserData.h>
#include <g3dif/Stream.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

class elem_pattern_anim_target
{
public:
    elem_pattern_anim_target()
        : sampler_name()
        , base_value(0.0f)
        , curve()
    {
    }

    template<typename T>
    elem_pattern_anim_target& operator=(const T& rhs)
    {
        sampler_name = rhs.sampler_name;
        base_value = rhs.base_value;
        curve = rhs.curve;
        return *this;
    }

    G3DIF_DEFINE_ELEM(pattern_anim_target);

    G3DIF_DEFINE_ATTRIB(std::string, sampler_name);
    G3DIF_DEFINE_ATTRIB(float, base_value);

    util::Optional<elem_anim_curve> curve;
};

class elem_tex_pattern_mat_anim
{
public:

    elem_tex_pattern_mat_anim()
        : mat_name()
    {
    }

    template<typename T>
    elem_tex_pattern_mat_anim& operator=(const T& rhs)
    {
        mat_name = rhs.mat_name;

        if( rhs.tex_pattern_anim_array )
        {
            pattern_anim_target_array.resize( rhs.tex_pattern_anim_array.Get().size() );
            int idxElem = 0;
            for( auto& elemNnPerMatAnim : rhs.tex_pattern_anim_array.Get() )
            {
                pattern_anim_target_array[idxElem] = elemNnPerMatAnim;
                ++idxElem;
            }
        }
        return *this;
    }

    G3DIF_DEFINE_ELEM_ARRAY(tex_pattern_mat_anim);

    G3DIF_DEFINE_ATTRIB(std::string, mat_name);

    std::vector<elem_pattern_anim_target> pattern_anim_target_array;
};

class elem_tex_pattern
{
public:

    elem_tex_pattern()
        : pattern_index(-1)
        , tex_name()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(tex_pattern);

    G3DIF_DEFINE_ATTRIB(int, pattern_index);
    G3DIF_DEFINE_ATTRIB(std::string, tex_name);
};

class elem_tex_pattern_anim_info
{
public:

    elem_tex_pattern_anim_info()
        : frame_count(0)
        , loop(true)
    {
    }

    template<typename T>
    elem_tex_pattern_anim_info& operator=(const T& rhs)
    {
        frame_count = rhs.frame_count;
        loop = rhs.loop;
        return *this;
    }

    G3DIF_DEFINE_ELEM(tex_pattern_anim_info);

    G3DIF_DEFINE_ATTRIB(int, frame_count);
    G3DIF_DEFINE_ATTRIB(bool, loop);
};

class elem_tex_pattern_anim
{
public:

    elem_tex_pattern_anim()
        : name()
        , path()
        , tex_pattern_anim_info()
        , tex_pattern_mat_anim_array()
        , user_data_array()
    {
    }

    template<typename T>
    elem_tex_pattern_anim& operator=(const T& rhs)
    {
        // tex_pattern_anim_info
    	tex_pattern_anim_info = rhs.material_anim_info;

        // tex_pattern_array
        tex_pattern_array.resize( rhs.tex_pattern_array.size() );
        int idxElem = 0;
        for( auto& elemNnPerMatAnim : rhs.tex_pattern_array )
        {
            tex_pattern_array[idxElem] = elemNnPerMatAnim;	// デフォルトの operator= を使用する。
            ++idxElem;
        }

        tex_pattern_mat_anim_array.resize( rhs.per_material_anim_array.size() );
        idxElem = 0;
        for( auto& elemNnPerMatAnim : rhs.per_material_anim_array )
        {
            tex_pattern_mat_anim_array[idxElem] = elemNnPerMatAnim;
            ++idxElem;
        }

        // stream_array
        stream_array.resize( rhs.stream_array.size() );
        idxElem = 0;
        for( auto& elemNnPerMatAnim : rhs.stream_array )
        {
            stream_array[idxElem] = elemNnPerMatAnim;	// デフォルトの operator= を使用する。
            ++idxElem;
        }

        // user_data_array
        user_data_array.resize( rhs.user_data_array.size() );
        idxElem = 0;
        for( auto& elemNnPerMatAnim : rhs.user_data_array )
        {
            user_data_array[idxElem] = elemNnPerMatAnim;	// デフォルトの operator= を使用する。
            ++idxElem;
        }

        return *this;
    }


    G3DIF_DEFINE_ELEM(tex_pattern_anim);

    G3DIF_DEFINE_ATTRIB(Version, version);

    void PostProcess();
    void PostBinaryProcess(void* data);
    void SetName(const char* fileName) { this->name.assign(fileName); }
    void SetPath(const char* filePath) { this->path.assign(filePath); }

    //! 読み込んだデータの整合性を確認します。
    void CheckData(int flag);

    std::string name;
    std::string path;

    elem_tex_pattern_anim_info tex_pattern_anim_info;
    std::vector<elem_tex_pattern> tex_pattern_array;
    std::vector<elem_tex_pattern_mat_anim> tex_pattern_mat_anim_array;
    std::vector<elem_stream> stream_array;
    std::vector<elem_user_data> user_data_array;
};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
