﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.Foundation.IO;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Resources;
using System.Text;
using System.Threading.Tasks;

namespace nw.g3d.toollib
{
    public class SimpleFilterToolParams
    {
        static SimpleFilterToolParams()
        {
            resourceManager = new ResourceManager("nw.g3d.toollib.Resources.SimpleFilterToolHelp", typeof(SimpleFilterToolParams).Assembly);
        }

        private static ResourceManager resourceManager;

        public static Func<string, string, string> CustomDescriptionConverterFunc { get; set; }

        public static string DescriptionConverter(string description, string name)
        {
            string value;
            if (CustomDescriptionConverterFunc != null)
            {
                value = CustomDescriptionConverterFunc(description.Replace("-", "_"), name);
                if (!string.IsNullOrEmpty(value))
                {
                    return value;
                }
            }

            value = resourceManager.GetString(description.Replace("-", "_"));
            Nintendo.Foundation.Contracts.Assertion.Operation.True(!string.IsNullOrEmpty(value));
            return value;
        }

        [CommandLineOption('s', "silent", Description = "silent", DescriptionConverterName = "DescriptionConverter")]
        public bool Silent { get; set; }

        [CommandLineOption('j', "jobs", Description = "jobs", DescriptionConverterName = "DescriptionConverter", ValueName = "number")]
        public int Job { get; set; }

        [CommandLineOption("enable-extension", Description = "enable-extension", DescriptionConverterName = "DescriptionConverter", ValueName = "extension")]
        public string EnableExtension { get; set; }

        [CommandLineOption("disable-extension", Description = "disable-extension", DescriptionConverterName = "DescriptionConverter", ValueName = "extension")]
        public string DisableExtension { get; set; }

        [CommandLineValues(CountMin = 1, Description = "paths", ValueName = "paths", DescriptionConverterName = "DescriptionConverter")]
        public string[] Paths { get; set; }

        [CommandLineArgFileOption("args-file", Description = "args-file", DescriptionConverterName = "DescriptionConverter")]
        public string ArgsFile { get; set; }
    }

    public class SimpleFilterToolParamsNotRequireXsdCheck : SimpleFilterToolParams
    {
        [CommandLineOption("disable-xsd-check", Description = "disable-xsd-check", DescriptionConverterName = "DescriptionConverter")]
        public bool DisableXsdCheck { get; set; }
    }
}
