﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace nw.g3d.toollib
{
    // 引数オプション
    public class ArgumentOption
    {
        // コンストラクタ
        public ArgumentOption(string optionString, string name)
        {
            _optionString = optionString;
            _name = name;
        }

        // 名前
        public string Name { get { return _name; } }

        // 値
        public string Value { get; set; }

        // 値を持っているか
        public bool HasValue { get { return (this.Value != null); } }

        public override string ToString()
        {
            return _optionString;
        }

        private readonly string _optionString;
        private readonly string _name;
    }
}
