﻿#----------------------------------------------------------------------------
# Project:  NintendoWare
#
# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.
#----------------------------------------------------------------------------

# 中間ファイルの更新、System.Xml.XmlDocument 型の doc を更新します
def Update(doc):

	# fsd 以外の <nw4f_3dif> version を 3.3.0 に変更します。
	if not doc.SelectSingleNode("/nw4f_3dif/shader_definition"):
		version = doc.SelectSingleNode("/nw4f_3dif/@version")
		version.Value = "3.3.0"

	# モデルの更新
	model = doc.SelectSingleNode("/nw4f_3dif/model")
	if model:
		UpdateModel(doc, model)
		return

#==========================================================
# モデルの更新
def UpdateModel(doc, model):

	# <shader_param> に depend を空文字列で追加します。
	for shader_param in model.SelectNodes(
		"material_array/material/shader_assign/shader_param_array/shader_param"):
		shader_param.SetAttribute("depend", "")

	for shape in model.SelectNodes("shape_array/shape"):
		# <shape> の子要素から <user_data_array>、<tool_data>、<user_tool_data> を削除します。
		user_data_array = shape.SelectSingleNode("user_data_array")
		if user_data_array:
			shape.RemoveChild(user_data_array)

		tool_data = shape.SelectSingleNode("tool_data")
		if tool_data:
			shape.RemoveChild(tool_data)

		user_tool_data = shape.SelectSingleNode("user_tool_data")
		if user_tool_data:
			shape.RemoveChild(user_tool_data)

		# <shape_info> の optimize_primitive_mode が none の場合、空文字列に変更します。
		shape_info = shape.SelectSingleNode("shape_info")
		optimize_primitive_mode = shape_info.GetAttribute("optimize_primitive_mode")
		if optimize_primitive_mode == "none":
			shape_info.SetAttribute("optimize_primitive_mode", "")

#==========================================================
