﻿#----------------------------------------------------------------------------
# Project:  NintendoWare
#
# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.
#----------------------------------------------------------------------------

# 中間ファイルの更新、System.Xml.XmlDocument 型の doc を更新します
def Update(doc):

	# fsd 以外の <nw4f_3dif> version を 3.0.0 に変更します。
	if not doc.SelectSingleNode("/nw4f_3dif/shader_definition"):
		version = doc.SelectSingleNode("/nw4f_3dif/@version")
		version.Value = "3.0.0"

	# モデルの更新
	model = doc.SelectSingleNode("/nw4f_3dif/model")
	if model:
		UpdateModel(doc, model)
		return

	# テクスチャの更新
	texture = doc.SelectSingleNode("/nw4f_3dif/texture")
	if texture:
		UpdateTexture(doc, texture)
		return

	# スケルタルアニメの更新
	skeletal_anim = doc.SelectSingleNode("/nw4f_3dif/skeletal_anim")
	if skeletal_anim:
		UpdateAnimInfo(skeletal_anim.SelectSingleNode("skeletal_anim_info"))
		return

	# シェーダパラメータアニメの更新
	shader_param_anim = doc.SelectSingleNode("/nw4f_3dif/shader_param_anim")
	if shader_param_anim:
		UpdateAnimInfo(shader_param_anim.SelectSingleNode("shader_param_anim_info"))
		return

	# テクスチャパターンアニメの更新
	tex_pattern_anim = doc.SelectSingleNode("/nw4f_3dif/tex_pattern_anim")
	if tex_pattern_anim:
		UpdateAnimInfo(tex_pattern_anim.SelectSingleNode("tex_pattern_anim_info"))
		return

	# ボーンビジビリティアニメの更新
	bone_visibility_anim = doc.SelectSingleNode("/nw4f_3dif/bone_visibility_anim")
	if bone_visibility_anim:
		UpdateAnimInfo(bone_visibility_anim.SelectSingleNode("bone_visibility_anim_info"))
		return

	# マテリアルビジビリティアニメの更新
	mat_visibility_anim = doc.SelectSingleNode("/nw4f_3dif/mat_visibility_anim")
	if mat_visibility_anim:
		UpdateAnimInfo(mat_visibility_anim.SelectSingleNode("mat_visibility_anim_info"))
		return

	# シェイプアニメの更新
	shape_anim = doc.SelectSingleNode("/nw4f_3dif/shape_anim")
	if shape_anim:
		UpdateAnimInfo(shape_anim.SelectSingleNode("shape_anim_info"))
		return

	# シーンアニメの更新
	scene_anim = doc.SelectSingleNode("/nw4f_3dif/scene_anim")
	if scene_anim:
		UpdateAnimInfo(scene_anim.SelectSingleNode("scene_anim_info"))
		return

#==========================================================
# モデルの更新
def UpdateModel(doc, model):

	# <model_info> に material_count、bone_count、shape_count、total_index、
	# total_vertex、total_process_vertex、total_triangle、process_vertex_per_triangle を
	# それぞれ 0 で追加します。
	model_info = model.SelectSingleNode("model_info")

	material_array = model.SelectSingleNode("material_array")
	if material_array:
		model_info.SetAttribute("material_count", str(material_array.ChildNodes.Count))
	else:
		model_info.SetAttribute("material_count", "0")

	bone_array = model.SelectSingleNode("skeleton/bone_array")
	model_info.SetAttribute("bone_count", str(bone_array.ChildNodes.Count))

	shape_array = model.SelectSingleNode("shape_array")
	if shape_array:
		model_info.SetAttribute("shape_count", str(shape_array.ChildNodes.Count))
	else:
		model_info.SetAttribute("shape_count", "0")

	smooth_skin_count = 0
	rigid_skin_count = 0
	for shape_info in model.SelectNodes("shape_array/shape/shape_info"):
		vertex_skinning_count = shape_info.GetAttribute("vertex_skinning_count")
		if vertex_skinning_count == "0":
			continue
		elif vertex_skinning_count == "1":
			rigid_skin_count += 1
		else:
			smooth_skin_count += 1
	model_info.SetAttribute("smooth_skinning_shape", str(smooth_skin_count))
	model_info.SetAttribute("rigid_skinning_shape", str(rigid_skin_count))

	smooth_matrix_count = 0
	rigid_matrix_count = 0
	for bone in model.SelectNodes("skeleton/bone_array/bone"):
		matrix_index = bone.GetAttribute("matrix_index").split()

		smooth_count = int(matrix_index[0]) + 1
		if smooth_count > smooth_matrix_count:
			smooth_matrix_count = smooth_count

		rigid_count = int(matrix_index[1]) + 1
		if rigid_count > rigid_matrix_count:
			rigid_matrix_count = rigid_count
	model_info.SetAttribute("smooth_skinning_matrix", str(smooth_matrix_count))
	if rigid_matrix_count == 0:
		model_info.SetAttribute("rigid_skinning_matrix", "0")
	else:
		model_info.SetAttribute("rigid_skinning_matrix", str(rigid_matrix_count - smooth_matrix_count))

	total_index = 0
	for mesh in model.SelectNodes("shape_array/shape/mesh"):
		total_index += int(mesh.GetAttribute("count"))
	model_info.SetAttribute("total_triangle", str(total_index / 3))
	model_info.SetAttribute("total_index", str(total_index))

	total_vertex = 0
	for vtx_attrib in model.SelectNodes("vertex_array/vertex/vtx_attrib_array/vtx_attrib[1]"):
		total_vertex += int(vtx_attrib.GetAttribute("count"))
	model_info.SetAttribute("total_vertex", str(total_vertex))

	model_info.SetAttribute("total_process_vertex", "0")
	model_info.SetAttribute("process_vertex_per_triangle", "0")

	# <model_info> に unite_pos_quantize を false で追加します。
	model_info.SetAttribute("unite_pos_quantize", "false")

	# <model_info> に dcc_preset を空文字で追加します。
	model_info.SetAttribute("dcc_preset", "")

	for material in model.SelectNodes("material_array/material"):

		# <shader_assign> に revision を 0 で追加します。
		shader_assign = material.SelectSingleNode("shader_assign")
		if not shader_assign:
			continue
		shader_assign.SetAttribute("revision", "0")

	for shape in model.SelectNodes("shape_array/shape"):
		shape_info = shape.SelectSingleNode("shape_info")

		# <shape_info> の original_shape_count が 0 だった場合に、1 を設定します。
		if shape_info.GetAttribute("original_shape_count") == "0":
			shape_info.SetAttribute("original_shape_count", "1")

		# <shape_info> に delete_near_vertex_mode を空文字列で追加します。
		shape_info.SetAttribute("delete_near_vertex_mode", "")

		# <shape_info> の render_priority を削除します。
		shape_info.RemoveAttribute("render_priority")

		mesh = shape.SelectSingleNode("mesh")

		# <shape> に <mesh_array> を length="1" で追加します。
		mesh_array = doc.CreateElement("mesh_array")
		mesh_array.SetAttribute("length", "1")
		shape.InsertAfter(mesh_array, mesh)

		# <mesh> に index="0" を追加し、<mesh_array> の内容に移動します。
		shape.RemoveChild(mesh)
		mesh.SetAttribute("index", "0")
		mesh_array.PrependChild(mesh)

#==========================================================
# テクスチャの更新
def UpdateTexture(doc, texture):

	texture_info = texture.SelectSingleNode("texture_info")

	# <texture_info> に mip_gen_filter を linear で追加します。
	texture_info.SetAttribute("mip_gen_filter", "linear")

	# <texture_info> に dcc_preset を空文字列で追加します。
	texture_info.SetAttribute("dcc_preset", "")

#==========================================================
# アニメ情報の更新
def UpdateAnimInfo(anim_info):
	# <skeletal_anim_info>、<shader_param_anim_info>、<tex_pattern_anim_info>、
	# <bone_visibility_anim_info>、<mat_visibility_anim_info>、<shape_anim_info>、
	# <scene_anim_info> に dcc_preset を空文字列で追加します。
	anim_info.SetAttribute("dcc_preset", "")

#==========================================================
