﻿using Nintendo.G3dTool.Entities;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;
using nw.g3d.toollib;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TextureCompositor
{
    public class TextureConverterOptions
    {
        public string Input { get; set; }
        public string Output { get; set; }
        public ComponentSelector CompSel { get; set; }
        public texture_info_quantize_typeType? Format { get; set; }
        public int? ResizeWidth { get; set; }
        public int? ResizeHeight { get; set; }

        public Bool4 Linear { get; set; }

        public override string ToString()
        {
            StringBuilder result = new StringBuilder();
            Nintendo.ToolFoundation.Contracts.Ensure.Operation.False(string.IsNullOrEmpty(Input));
            result.Append($"{Input}");
            result.Append($" --output {Output}");
            if (this.CompSel != null)
            {
                result.Append($" --comp-sel {CompSel.ToString().Replace(" ", string.Empty)}");
            }
            if (Format != null)
            {
                result.Append($" --format {Format.ToString()}");
            }
            if (ResizeWidth != null)
            {
                result.Append($" --resize-w {ResizeWidth}");
            }
            if (ResizeHeight != null)
            {
                result.Append($" --resize-w {ResizeHeight}");
            }

            if (this.Linear != null)
            {
                string linearValue = string.Empty;
                linearValue += this.Linear.X ? "1" : "0";
                linearValue += this.Linear.Y ? "1" : "0";
                linearValue += this.Linear.Z ? "1" : "0";
                linearValue += this.Linear.W ? "1" : "0";
                result.Append($" --linear {linearValue}");
            }
            else
            {
                // 指定がない場合、入力画像のものをとりあえず使っておく
                var file = IfBinaryReadUtility.ReadIntermediateFileWithoutStreams(Input, G3dToolUtility.GetXsdBasePath());
                var tex = file.GetRootEntity<Texture>();
                string linearValue = string.Empty;
                linearValue += tex.TextureInfo.Linear.X ? "1" : "0";
                linearValue += tex.TextureInfo.Linear.Y ? "1" : "0";
                linearValue += tex.TextureInfo.Linear.Z ? "1" : "0";
                linearValue += tex.TextureInfo.Linear.W ? "1" : "0";
                result.Append($" --linear {linearValue}");
            }

            return result.ToString().Trim();
        }
    }
}
