﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Reflection;
using System.Windows.Forms;

namespace nw.g3d.nw4f_3dif
{
    /// <summary>
    /// バージョン情報
    /// </summary>
    public static class G3dVersionInformation
    {
        /// <summary>
        /// 名前
        /// </summary>
        public static string Name { get { return Application.ProductName; } }

        /// <summary>
        /// バージョン
        /// </summary>
        public static string Version { get { return Application.ProductVersion; } }

        /// <summary>
        /// NintendoWare for Cafe
        /// </summary>
        public const string NW4F = "NW4F";

        /// <summary>
        /// 会社
        /// </summary>
        public const string Company = "Nintendo Co., Ltd.";

        /// <summary>
        /// コピーライト
        /// </summary>
        public const string Copyright =
            "Copyright (C) Nintendo Co., Ltd. All rights reserved.";

        /// <summary>
        /// ビルド日時
        /// </summary>
        public static DateTime BuildDateTime
        {
            get
            {
                Assembly entry = Assembly.GetEntryAssembly();
                Version version = entry.GetName().Version;
                DateTime buildDate = new DateTime(2000, 1, 1, 0, 0, 0);
                buildDate = buildDate.AddDays((double)version.Build);
                buildDate = buildDate.AddSeconds((double)version.Revision * 2.0);
                return buildDate;
            }
        }

        /// <summary>
        /// リビジョン
        /// </summary>
        public static string Revision
        {
            get
            {
                Assembly entry = Assembly.GetEntryAssembly();
                FileVersionInfo fileVersionInfo = FileVersionInfo.GetVersionInfo(entry.Location);
                string[] versions = fileVersionInfo.FileVersion.Split('.');
                Nintendo.Foundation.Contracts.Assertion.Operation.True(versions.Length == 4);
                return versions[3];
            }
        }

        /// <summary>
        /// バージョン情報の取得
        /// </summary>
        /// <returns>バージョン情報</returns>
        public static string GetVersionInfromation()
        {
            return string.Format("{0} {1} ({2})\r\n  {3}\r\n",
                G3dVersionInformation.Name,
                G3dVersionInformation.Version,
                G3dVersionInformation.BuildDateTime,
                G3dVersionInformation.Copyright);
        }
    }
}
