﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace nw4f.meshlib
{
    public class ResizableList<T> : List<T>
    {
        public ResizableList()
        {
        }
        public ResizableList(ResizableList<T> rhs)
            : base(rhs as List<T>)
        {
        }

        public ResizableList(ICollection<T> rhs)
            : base(rhs)
        {
        }

        public static ResizableList<CL> Clone<CL>(ResizableList<CL> listToClone) where CL : ICloneable
        {
            ResizableList<CL> test = new ResizableList<CL>();
            foreach (var v in listToClone)
            {
                test.Add((CL)v.Clone());
            }
            return test;
        }

        public void Resize(int len, T defVal)
        {
            try
            {
                int num = len - Count;
                if (num > 0)
                {
                    Capacity = len;
                    for (int i = 0; i < num; i++)
                    {
                        Add(defVal);
                    }
                }
                else if (num < 0)
                {
                    RemoveRange(len, -num);
                }
            }
            catch (Exception ex)
            {
                throw ExcepHandle.CreateException("Fail to resize list", ex);
            }
        }
    }
}
