﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using nw.g3d.iflib;

namespace nw4f.meshlib
{
    internal class ExcepHandle
    {
        public static Exception CreateException(string message,
            [System.Runtime.CompilerServices.CallerMemberName] string memberName = "",
            [System.Runtime.CompilerServices.CallerFilePath] string sourceFilePath = "",
            [System.Runtime.CompilerServices.CallerLineNumber] int sourceLineNumber = 0)
        {
            nw.g3d.iflib.src.Optimize.Model.IfModelPolygonReductionOptimizer.WriteLog(_3dIntermediateFilePlygonReduction.IfStrings.Get("PolygonReduction_InternalExceptionMsg", memberName,
                Path.GetFileName(sourceFilePath), sourceLineNumber));
            return new Exception(message);
        }

        public static Exception CreateException(string message,
            Exception ex,
            [System.Runtime.CompilerServices.CallerMemberName] string memberName = "",
            [System.Runtime.CompilerServices.CallerFilePath] string sourceFilePath = "",
            [System.Runtime.CompilerServices.CallerLineNumber] int sourceLineNumber = 0)
        {
            nw.g3d.iflib.src.Optimize.Model.IfModelPolygonReductionOptimizer.WriteLog(_3dIntermediateFilePlygonReduction.IfStrings.Get("PolygonReduction_InternalExceptionMsg", memberName,
                Path.GetFileName(sourceFilePath), sourceLineNumber));
            return new Exception(message, ex);
        }

        public static Exception CreateException(Exception ex,
            [System.Runtime.CompilerServices.CallerMemberName] string memberName = "",
            [System.Runtime.CompilerServices.CallerFilePath] string sourceFilePath = "",
            [System.Runtime.CompilerServices.CallerLineNumber] int sourceLineNumber = 0)
        {
            nw.g3d.iflib.src.Optimize.Model.IfModelPolygonReductionOptimizer.WriteLog(_3dIntermediateFilePlygonReduction.IfStrings.Get("PolygonReduction_InternalExceptionMsg", memberName,
                Path.GetFileName(sourceFilePath), sourceLineNumber));
            return new Exception(ex.Message);
        }
    }
}
