﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using IronPython.Hosting;
using Microsoft.Scripting.Hosting;

namespace nw.g3d.iflib
{
    /// <summary>
    /// IronPython を使用するスクリプト処理に関するユーティリティです。
    /// </summary>
    public static class IfScriptingUtility
    {
        private static readonly string LibraryDirectoryPath = @"..\3dTools\Lib";

        /// <summary>
        /// 探索パスに GraphicsTools\Lib 以下を追加した Python の ScriptEngine を作成します。
        /// </summary>
        /// <returns>作成した Python の ScriptEngine</returns>
        public static ScriptEngine CreateEngine()
        {
            var engine = Python.CreateEngine();
            var paths = engine.GetSearchPaths();
            string additionalPythonPath = Path.Combine(
                AppDomain.CurrentDomain.BaseDirectory,
                LibraryDirectoryPath);
            if (!Directory.Exists(additionalPythonPath))
            {
                // デバッグ版ビルド実行時用
                additionalPythonPath = Path.Combine(
                    @"../../../../../../../../../Tools/Graphics/3dTools",
                    LibraryDirectoryPath);
            }

            paths.Add(additionalPythonPath);
            engine.SetSearchPaths(paths);
            return engine;
        }
    }
}
