﻿using Nintendo.G3dTool.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

namespace nw.g3d.iflib.nw3de
{
    [Serializable]
    public class nw3de_ParentMaterialInfo : ToolDataObject
    {
        public List<ParentMaterialInfo> ParentMaterialInfos { get; set; }

        public nw3de_ParentMaterialInfo()
        {
            ParentMaterialInfos = new List<ParentMaterialInfo>();
        }

        public void ClearEmptyItems()
        {
            ParentMaterialInfos = ParentMaterialInfos.Where(x => !x.Empty()).ToList();
        }
    }

    [Serializable]
    public class ParentMaterialInfo
    {
        // 対象マテリアル名
        [XmlAttribute]
        public string MaterialName { get; set; }

        [XmlElement("ParentMaterial")]
        public List<ParentMaterial> ParentMaterials { get; set; }


        public bool Empty()
        {
            return ParentMaterials == null || !ParentMaterials.Any();
        }
    }
}
