﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace nw.g3d.iflib
{
    public class IfPseudoVertexCacheFIFO : IfPseudoVertexCache
    {
        public const int CafeCacheSize = 14;

        private Queue<int> vertexCacheQueue = new Queue<int>();

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public IfPseudoVertexCacheFIFO()
        {
            this.VertexCacheSize = CafeCacheSize;
        }

        /// <summary>
        /// 頂点キャッシュのサイズです。
        /// </summary>
        public int VertexCacheSize { get; set; }

        /// <summary>
        /// 頂点キャッシュを初期状態に戻します。
        /// </summary>
        public void Clear()
        {
            this.vertexCacheQueue.Clear();
        }

        /// <summary>
        /// 任意の座標IDがキャッシュされているかを取得します。
        /// </summary>
        /// <param name="positionId">確認したい座標IDです。</param>
        /// <returns>キャッシュされてれば true を返します。</returns>
        public bool IsContains(int positionId)
        {
            return this.vertexCacheQueue.Contains(positionId);
        }

        /// <summary>
        /// キューの末尾に座標IDを追加します。
        /// キャッシュ数を超えると先頭からIDを削除します。
        /// </summary>
        /// <param name="positionId">座標IDです。</param>
        public void EnqueuePosition(int positionId)
        {
            this.vertexCacheQueue.Enqueue(positionId);
            while (this.VertexCacheSize < this.vertexCacheQueue.Count)
            {
                int front = this.vertexCacheQueue.Dequeue();
            }
        }
    }
}
