﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nw.g3d.nw4f_3dif;
using System.Collections;
using System.Xml;
using System.Diagnostics;
using System.Text.RegularExpressions;

namespace nw.g3d.iflib
{
    // モデルのサブメッシュ結合
    public class IfModelUniteSubmeshOptimizer : IfModelOptimizer
    {
        // コンストラクタ
        public IfModelUniteSubmeshOptimizer() :
            base("IfModelUniteSubmeshOptimizer_Log") { }

        // プロセス
        public override string Process
        {
            get { return "unite_submesh"; }
        }

        public override string ToString()
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendLine(string.Format("{0}\n{1}", base.ToString(), GetResult()));
            return builder.ToString();
        }

        public override string GetResult()
        {
            StringBuilder builder = new StringBuilder();
            for (int shapeIndex = 0; shapeIndex < ShapeCount; ++shapeIndex)
            {
                builder.AppendLine(string.Format("{2,3} => {1,-3} ({0})", ShapeName[shapeIndex], AfterSubmeshCount[shapeIndex], BeforeSubmeshCount[shapeIndex]));
            }
            return builder.ToString();
        }

        private int ShapeCount { get; set; }
        private string[] ShapeName { get { return shapeName; } }
        private int[] BeforeSubmeshCount { get { return beforeSubmeshCount; } }
        private int[] AfterSubmeshCount { get { return afterSubmeshCount; } }
        private string[] shapeName = null;
        private int[] beforeSubmeshCount = null;
        private int[] afterSubmeshCount = null;

        // 最適化
        protected override void Optimize()
        {
            // TODO: Unite モデル対応
            // これより下は Unite されたモデルにまだ対応していない。
            foreach (shapeType shape in this.Target.shape_array.shape)
            {
                if (shape.mesh_array.mesh.Length > 1)
                {
                    IfStrings.Throw("IfModelOptimizer_Error_UnitedModelUnsupported");
                }
            }

            if (this.Target.shape_array == null ||
                this.Target.shape_array.shape == null) { return; }

            ShapeCount = this.Target.shape_array.Count;
            shapeName = new string[ShapeCount];
            beforeSubmeshCount = new int[ShapeCount];
            afterSubmeshCount = new int[ShapeCount];

            G3dParallel.ForEach(this.Target.shape_array.shape, delegate(shapeType shape)
            {
                shapeName[shape.index] = shape.name;
                beforeSubmeshCount[shape.index] = shape.mesh_array.mesh[0].submesh_array.Count;

                submeshType[] submeshArray = new submeshType[1];
                submeshType submesh = new submeshType();
                submesh.offset = 0;
                submesh.count = shape.mesh_array.mesh[0].count;
                submeshArray[0] = submesh;

                shape.mesh_array.mesh[0].submesh_array.submesh = submeshArray;
                shape.shape_info.divide_submesh_mode = string.Empty;

                afterSubmeshCount[shape.index] = shape.mesh_array.mesh[0].submesh_array.Count;
            });
        }
    }
}
