﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    public class IfBoneVisibilityAnimMergeContext
    {
        // コンストラクタ
        public IfBoneVisibilityAnimMergeContext(
            bone_visibility_animType newBoneVisAnim,
            List<G3dStream> newStreams,
            bone_visibility_animType oldBoneVisAnim,
            List<G3dStream> oldStreams)
        {
            this.NewBoneVisAnim = newBoneVisAnim;
            this.NewStreams = newStreams;
            this.OldBoneVisAnim = oldBoneVisAnim;
            this.OldStreams = oldStreams;
        }

        // セットアップ
        public void Setup()
        {
            // ボーンビジビリティアニメーションがない場合はセットアップしない
            if (this.NewBoneVisAnim.bone_vis_bone_anim_array == null ||
                this.NewBoneVisAnim.bone_vis_bone_anim_array.bone_vis_bone_anim == null ||
                this.OldBoneVisAnim.bone_vis_bone_anim_array == null ||
                this.OldBoneVisAnim.bone_vis_bone_anim_array.bone_vis_bone_anim == null)
            {
                return;
            }

            // <bone_vis_bone_anim> 名前一致でマージ
            IfMergeUtility.SetupTableByName<bone_vis_bone_animType>(this.BoneVisibilityTable,
                this.NewBoneVisAnim.bone_vis_bone_anim_array.bone_vis_bone_anim,
                this.OldBoneVisAnim.bone_vis_bone_anim_array.bone_vis_bone_anim);
        }

        //=====================================================================
        // 再出力した新しいボーンビジビリティアニメーション、マージ先
        public readonly bone_visibility_animType NewBoneVisAnim;
        // 再出力した新しいストリーム、マージ先
        public readonly List<G3dStream> NewStreams;
        // 編集済みの古いボーンビジビリティアニメーション、マージ元
        public readonly bone_visibility_animType OldBoneVisAnim;
        // 編集済みの古いストリーム、マージ元
        public readonly List<G3dStream> OldStreams;

        // マージテーブル
        public readonly Dictionary<bone_vis_bone_animType, bone_vis_bone_animType>
            BoneVisibilityTable = new Dictionary<bone_vis_bone_animType, bone_vis_bone_animType>();
    }
}
