﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Diagnostics;
using System.IO;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // テキストテクスチャパターンアニメーション中間ファイルフォーマッタ
    internal static class IfTextTexPatternAnimFormatter
    {
        // tex_pattern_anim のフォーマット
        internal static void Format(TextReader rd, TextWriter wt)
        {
            // tex_pattern_anim
            wt.WriteLine($"<{G3dConstant.TexPatternAnimElementName} {rd.ReadLine()}");

            // process_log
            string process_log_array = rd.ReadLine();
            string tex_pattern_anim_info;
            if (process_log_array == "<process_log_array")
            {
                IfTextFormatterUtility.Format_process_log_array(rd, wt);
                tex_pattern_anim_info = rd.ReadLine();
            }
            else
            {
                tex_pattern_anim_info = process_log_array;
            }

            // tex_pattern_anim_info
            Nintendo.Foundation.Contracts.Assertion.Operation.True(tex_pattern_anim_info == "<tex_pattern_anim_info");
            FormatTexPatternAnimInfo(rd, wt);

            // tex_pattern
            string tex_pattern_array = rd.ReadLine();
            string tex_pattern_mat_anim_array;
            if (tex_pattern_array == "<tex_pattern_array")
            {
                Format_tex_pattern(rd, wt);
                tex_pattern_mat_anim_array = rd.ReadLine();
            }
            else
            {
                tex_pattern_mat_anim_array = tex_pattern_array;
            }

            // tex_pattern_mat_anim_array
            string user_data_array;
            if (tex_pattern_mat_anim_array == "<tex_pattern_mat_anim_array")
            {
                Format_tex_pattern_mat_anim(rd, wt);
                user_data_array = rd.ReadLine();
            }
            else
            {
                user_data_array = tex_pattern_mat_anim_array;
            }

            // user_data
            string stream_array;
            if (user_data_array == "<user_data_array")
            {
                IfTextFormatterUtility.Format_user_data_array(rd, wt, string.Empty);
                stream_array = rd.ReadLine();
            }
            else
            {
                stream_array = user_data_array;
            }

            // stream
            string comment;
            if (stream_array == "<stream_array")
            {
                IfTextFormatterUtility.Format_stream(rd, wt);
                comment = rd.ReadLine();
            }
            else
            {
                comment = stream_array;
            }

            // comment
            string tool_data;
            if (comment == "<comment")
            {
                IfTextFormatterUtility.FormatComment(rd, wt, string.Empty);
                tool_data = rd.ReadLine();
            }
            else
            {
                tool_data = comment;
            }

            // tool_data
            string user_tool_data;
            if (tool_data == "<tool_data>")
            {
                IfTextFormatterUtility.FormatToolData(rd, wt, string.Empty);
                user_tool_data = rd.ReadLine();
            }
            else
            {
                user_tool_data = tool_data;
            }

            // user_tool_data
            string close_tex_pattern_anim;
            if (user_tool_data == "<user_tool_data>")
            {
                IfTextFormatterUtility.FormatUserToolData(rd, wt, string.Empty);
                close_tex_pattern_anim = rd.ReadLine();
            }
            else
            {
                close_tex_pattern_anim = user_tool_data;
            }

            Nintendo.Foundation.Contracts.Assertion.Operation.True(close_tex_pattern_anim == "</tex_pattern_anim>");
            wt.WriteLine(close_tex_pattern_anim);
        }

        //---------------------------------------------------------------------
        #region tex_pattern_anim_info
        // tex_pattern_anim_info のフォーマット
        private static void FormatTexPatternAnimInfo(TextReader rd, TextWriter wt)
        {
            // tex_pattern_anim_info
            wt.WriteLine("<tex_pattern_anim_info {0} {1}", rd.ReadLine(), rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", IfTextFormatterUtility.RemoveSlashBracket(rd.ReadLine()));
            wt.WriteLine("/>");
        }
        #endregion

        //---------------------------------------------------------------------
        #region tex_pattern
        // tex_pattern のフォーマット
        internal static void Format_tex_pattern(TextReader rd, TextWriter wt)
        {
            // tex_pattern_array
            wt.WriteLine("<tex_pattern_array {0}", rd.ReadLine());

            while (true)
            {
                // tex_pattern
                string tex_pattern = rd.ReadLine();
                if (tex_pattern != "<tex_pattern")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(tex_pattern == "</tex_pattern_array>");
                    wt.WriteLine("{0}", tex_pattern);
                    break;
                }
                wt.WriteLine("\t{0} {1} {2}",
                    tex_pattern, rd.ReadLine(), rd.ReadLine());
            }
        }
        #endregion

        //---------------------------------------------------------------------
        // tex_pattern_mat_anim のフォーマット
        private static void Format_tex_pattern_mat_anim(TextReader rd, TextWriter wt)
        {
            // tex_pattern_mat_anim_array
            wt.WriteLine("<tex_pattern_mat_anim_array {0}", rd.ReadLine());

            while (true)
            {
                // tex_pattern_mat_anim
                string tex_pattern_mat_anim = rd.ReadLine();
                if (tex_pattern_mat_anim != "<tex_pattern_mat_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(tex_pattern_mat_anim == "</tex_pattern_mat_anim_array>");
                    wt.WriteLine("{0}", tex_pattern_mat_anim);
                    break;
                }
                wt.WriteLine("\t{0} {1} {2}",
                    tex_pattern_mat_anim, rd.ReadLine(), rd.ReadLine());

                string close_tex_pattern_mat_anim = Format_pattern_anim_target(rd, wt);
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_tex_pattern_mat_anim == "</tex_pattern_mat_anim>");
                wt.WriteLine("\t{0}", close_tex_pattern_mat_anim);
            }
        }

        // pattern_anim_target のフォーマット
        private static string Format_pattern_anim_target(TextReader rd, TextWriter wt)
        {
            while (true)
            {
                // pattern_anim_target
                string pattern_anim_target = rd.ReadLine();
                if (pattern_anim_target != "<pattern_anim_target")
                {
                    return pattern_anim_target;
                }
                string name = rd.ReadLine();
                string hint = rd.ReadLine();
                string base_value = rd.ReadLine();
                wt.WriteLine("\t\t{0} {1} {2} {3}",
                    pattern_anim_target, name, hint, base_value);
                if (base_value.EndsWith(" />")) { continue; }

                // step_curve
                string step_curve = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(step_curve == "<step_curve");
                IfTextFormatterUtility.Format_step_curve(rd, wt, "\t\t\t");

                string close_pattern_anim_target = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_pattern_anim_target == "</pattern_anim_target>");
                wt.WriteLine("\t\t{0}", close_pattern_anim_target);
            }
        }
    }
}
