﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Diagnostics;
using System.IO;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // テキストシェーダーパラメーターアニメーション中間ファイルフォーマッタ
    internal static class IfTextShaderParamAnimFormatter
    {
        // shader_param_anim のフォーマット
        internal static void Format(TextReader rd, TextWriter wt)
        {
            // shader_param_anim
            wt.WriteLine($"<{G3dConstant.ShaderParamAnimElementName} {rd.ReadLine()}");

            // process_log
            string process_log_array = rd.ReadLine();
            string shader_param_anim_info;
            if (process_log_array == "<process_log_array")
            {
                IfTextFormatterUtility.Format_process_log_array(rd, wt);
                shader_param_anim_info = rd.ReadLine();
            }
            else
            {
                shader_param_anim_info = process_log_array;
            }

            // shader_param_anim_info
            Nintendo.Foundation.Contracts.Assertion.Operation.True(shader_param_anim_info == "<shader_param_anim_info");
            FormatShaderParamAnimInfo(rd, wt);

            // shader_param_mat_anim_array
            string shader_param_mat_anim_array = rd.ReadLine();
            string original_material_anim_array;
            if (shader_param_mat_anim_array == "<shader_param_mat_anim_array")
            {
                Format_shader_param_mat_anim(rd, wt);
                original_material_anim_array = rd.ReadLine();
            }
            else
            {
                original_material_anim_array = shader_param_mat_anim_array;
            }

            // original_material_anim_array
            string user_data_array;
            if (original_material_anim_array == "<original_material_anim_array")
            {
                Format_original_material_anim(rd, wt);
                user_data_array = rd.ReadLine();
            }
            else
            {
                user_data_array = original_material_anim_array;
            }

            // user_data
            string stream_array;
            if (user_data_array == "<user_data_array")
            {
                IfTextFormatterUtility.Format_user_data_array(rd, wt, string.Empty);
                stream_array = rd.ReadLine();
            }
            else
            {
                stream_array = user_data_array;
            }

            // stream
            string comment;
            if (stream_array == "<stream_array")
            {
                IfTextFormatterUtility.Format_stream(rd, wt);
                comment = rd.ReadLine();
            }
            else
            {
                comment = stream_array;
            }

            // comment
            string tool_data;
            if (comment == "<comment")
            {
                IfTextFormatterUtility.FormatComment(rd, wt, string.Empty);
                tool_data = rd.ReadLine();
            }
            else
            {
                tool_data = comment;
            }

            // tool_data
            string user_tool_data;
            if (tool_data == "<tool_data>")
            {
                IfTextFormatterUtility.FormatToolData(rd, wt, string.Empty);
                user_tool_data = rd.ReadLine();
            }
            else
            {
                user_tool_data = tool_data;
            }

            // user_tool_data
            string close_shader_param_anim;
            if (user_tool_data == "<user_tool_data>")
            {
                IfTextFormatterUtility.FormatUserToolData(rd, wt, string.Empty);
                close_shader_param_anim = rd.ReadLine();
            }
            else
            {
                close_shader_param_anim = user_tool_data;
            }

            Nintendo.Foundation.Contracts.Assertion.Operation.True(close_shader_param_anim == "</shader_param_anim>");
            wt.WriteLine(close_shader_param_anim);
        }

        //---------------------------------------------------------------------
        #region shader_param_anim_info
        // shader_param_anim_info のフォーマット
        private static void FormatShaderParamAnimInfo(TextReader rd, TextWriter wt)
        {
            // shader_param_anim_info
            wt.WriteLine("<shader_param_anim_info {0} {1}", rd.ReadLine(), rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", IfTextFormatterUtility.RemoveSlashBracket(rd.ReadLine()));
            wt.WriteLine("/>");
        }
        #endregion

        //---------------------------------------------------------------------
        #region shader_param_mat_anim
        // shader_param_mat_anim のフォーマット
        private static void Format_shader_param_mat_anim(TextReader rd, TextWriter wt)
        {
            // shader_param_mat_anim_array
            wt.WriteLine("<shader_param_mat_anim_array {0}", rd.ReadLine());

            while (true)
            {
                // shader_param_mat_anim
                string shader_param_mat_anim = rd.ReadLine();
                if (shader_param_mat_anim != "<shader_param_mat_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(shader_param_mat_anim == "</shader_param_mat_anim_array>");
                    wt.WriteLine("{0}", shader_param_mat_anim);
                    break;
                }
                wt.WriteLine("\t{0} {1} {2}",
                    shader_param_mat_anim, rd.ReadLine(), rd.ReadLine());

                // param_anim_array
                string param_anim_array = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(param_anim_array == "<param_anim_array");
                Format_param_anim(rd, wt);

                string close_shader_param_mat_anim = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_shader_param_mat_anim == "</shader_param_mat_anim>");
                wt.WriteLine("\t{0}", close_shader_param_mat_anim);
            }
        }

        // param_anim のフォーマット
        private static void Format_param_anim(TextReader rd, TextWriter wt)
        {
            // param_anim_array
            wt.WriteLine("\t\t<param_anim_array {0}", rd.ReadLine());

            while (true)
            {
                // param_anim
                string param_anim = rd.ReadLine();
                if (param_anim != "<param_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(param_anim == "</param_anim_array>");
                    wt.WriteLine("\t\t{0}", param_anim);
                    break;
                }
                wt.WriteLine("\t\t\t{0} {1} {2} {3}",
                    param_anim, rd.ReadLine(), rd.ReadLine(), rd.ReadLine());
                wt.WriteLine("\t\t\t\t{0}", IfTextFormatterUtility.RemoveBracket(rd.ReadLine()));
                wt.WriteLine("\t\t\t>");

                string close_param_anim = Format_param_anim_target(rd, wt);
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_param_anim == "</param_anim>");
                wt.WriteLine("\t\t\t{0}", close_param_anim);
            }
        }

        // param_anim_target のフォーマット
        internal static string Format_param_anim_target(TextReader rd, TextWriter wt)
        {
            while (true)
            {
                // param_anim_target
                string param_anim_target = rd.ReadLine();
                if (param_anim_target != "<param_anim_target")
                {
                    return param_anim_target;
                }
                string component_index = rd.ReadLine();
                string base_value = rd.ReadLine();
                wt.WriteLine("\t\t\t\t{0} {1} {2}",
                    param_anim_target, component_index, base_value);
                if (base_value.EndsWith(" />")) { continue; }

                // curve
                IfTextFormatterUtility.FormatCurve(rd, wt, "\t\t\t\t\t");

                string close_param_anim_target = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_param_anim_target == "</param_anim_target>");
                wt.WriteLine("\t\t\t\t{0}", close_param_anim_target);
            }
        }
        #endregion

        //---------------------------------------------------------------------
        #region original_material_anim
        // original_material_anim のフォーマット
        private static void Format_original_material_anim(TextReader rd, TextWriter wt)
        {
            // original_material_anim_array
            wt.WriteLine("<original_material_anim_array {0}", rd.ReadLine());

            while (true)
            {
                // original_material_anim
                string original_material_anim = rd.ReadLine();
                if (original_material_anim != "<original_material_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(original_material_anim == "</original_material_anim_array>");
                    wt.WriteLine("{0}", original_material_anim);
                    break;
                }
                string index = rd.ReadLine();
                string name = rd.ReadLine();
                wt.WriteLine("\t{0} {1} {2}", original_material_anim, index, name);
                if (name.EndsWith(" />")) { continue; }

                // original_color_anim
                string original_color_anim_array = rd.ReadLine();
                string original_texsrt_anim_array;
                if (original_color_anim_array == "<original_color_anim_array")
                {
                    Format_original_color_anim(rd, wt);
                    original_texsrt_anim_array = rd.ReadLine();
                }
                else
                {
                    original_texsrt_anim_array = original_color_anim_array;
                }

                // original_texsrt_anim
                string close_original_material_anim;
                if (original_texsrt_anim_array == "<original_texsrt_anim_array")
                {
                    Format_original_texsrt_anim(rd, wt);
                    close_original_material_anim = rd.ReadLine();
                }
                else
                {
                    close_original_material_anim = original_texsrt_anim_array;
                }

                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_original_material_anim == "</original_material_anim>");
                wt.WriteLine("\t{0}", close_original_material_anim);
            }
        }

        // original_color_anim のフォーマット
        internal static void Format_original_color_anim(TextReader rd, TextWriter wt)
        {
            // original_color_anim_array
            wt.WriteLine("\t\t<original_color_anim_array {0}", rd.ReadLine());

            while (true)
            {
                // original_color_anim
                string original_color_anim = rd.ReadLine();
                if (original_color_anim != "<original_color_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(original_color_anim == "</original_color_anim_array>");
                    wt.WriteLine("\t\t{0}", original_color_anim);
                    break;
                }
                wt.WriteLine("\t\t\t{0} {1} {2}",
                    original_color_anim, rd.ReadLine(), rd.ReadLine());

                string close_original_color_anim = Format_original_color_anim_target(rd, wt);
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_original_color_anim == "</original_color_anim>");
                wt.WriteLine("\t\t\t{0}", close_original_color_anim);
            }
        }

        // original_color_anim_target のフォーマット
        private static string Format_original_color_anim_target(TextReader rd, TextWriter wt)
        {
            while (true)
            {
                // original_color_anim_target
                string original_color_anim_target = rd.ReadLine();
                if (original_color_anim_target != "<original_color_anim_target")
                {
                    return original_color_anim_target;
                }

                string target = rd.ReadLine();
                string base_value = rd.ReadLine();
                wt.WriteLine("\t\t\t\t{0} {1} {2}",
                    original_color_anim_target, target, base_value);
                if (base_value.EndsWith(" />")) { continue; }

                // オリジナルカーブのフォーマット
                FormatOriginalCurve(rd, wt);

                string close_original_color_anim_target = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_original_color_anim_target == "</original_color_anim_target>");
                wt.WriteLine("\t\t\t\t{0}", close_original_color_anim_target);
            }
        }

        // original_texsrt_anim のフォーマット
        internal static void Format_original_texsrt_anim(TextReader rd, TextWriter wt)
        {
            // original_texsrt_anim_array
            wt.WriteLine("\t\t<original_texsrt_anim_array {0}", rd.ReadLine());

            while (true)
            {
                // original_texsrt_anim
                string original_texsrt_anim = rd.ReadLine();
                if (original_texsrt_anim != "<original_texsrt_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(original_texsrt_anim == "</original_texsrt_anim_array>");
                    wt.WriteLine("\t\t{0}", original_texsrt_anim);
                    break;
                }
                wt.WriteLine("\t\t\t{0} {1} {2}",
                    original_texsrt_anim, rd.ReadLine(), rd.ReadLine());
                wt.WriteLine("\t\t\t\t{0}",
                    IfTextFormatterUtility.RemoveBracket(rd.ReadLine()));
                wt.WriteLine("\t\t\t>");

                string close_original_texsrt_anim = Format_original_texsrt_anim_target(rd, wt);
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_original_texsrt_anim == "</original_texsrt_anim>");
                wt.WriteLine("\t\t\t{0}", close_original_texsrt_anim);
            }
        }

        // original_texsrt_anim_target のフォーマット
        private static string Format_original_texsrt_anim_target(TextReader rd, TextWriter wt)
        {
            while (true)
            {
                // original_texsrt_anim_target
                string original_texsrt_anim_target = rd.ReadLine();
                if (original_texsrt_anim_target != "<original_texsrt_anim_target")
                {
                    return original_texsrt_anim_target;
                }

                string target = rd.ReadLine();
                string base_value = rd.ReadLine();
                wt.WriteLine("\t\t\t\t{0} {1} {2}",
                    original_texsrt_anim_target, target, base_value);
                if (base_value.EndsWith(" />")) { continue; }

                // オリジナルカーブのフォーマット
                FormatOriginalCurve(rd, wt);

                string close_original_texsrt_anim_target = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_original_texsrt_anim_target == "</original_texsrt_anim_target>");
                wt.WriteLine("\t\t\t\t{0}", close_original_texsrt_anim_target);
            }
        }
        #endregion

        //---------------------------------------------------------------------
        #region original_curve
        // オリジナルカーブのフォーマット
        private static void FormatOriginalCurve(TextReader rd, TextWriter wt)
        {
            string curve = rd.ReadLine();
            switch (curve)
            {
                case "<original_hermite":
                    Format_original_hermite(rd, wt);
                    break;
                case "<original_linear":
                    Format_original_linear(rd, wt);
                    break;
                case "<original_step":
                    Format_original_step(rd, wt);
                    break;
                default:
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(false);
                    break;
            }
        }

        // original_hermite
        private static void Format_original_hermite(TextReader rd, TextWriter wt)
        {
            string indent = "\t\t\t\t\t";
            wt.WriteLine("{0}<original_hermite {1}", indent, rd.ReadLine());
            wt.WriteLine("{0}\t{1} {2}", indent, rd.ReadLine(), rd.ReadLine());
            wt.WriteLine("{0}\t{1}", indent, rd.ReadLine());
            wt.WriteLine("{0}\t{1}",
                indent, IfTextFormatterUtility.RemoveSlashBracket(rd.ReadLine()));
            wt.WriteLine("{0}/>", indent);
        }

        // original_linear
        private static void Format_original_linear(TextReader rd, TextWriter wt)
        {
            string indent = "\t\t\t\t\t";
            wt.WriteLine("{0}<original_linear {1}", indent, rd.ReadLine());
            wt.WriteLine("{0}\t{1} {2}", indent, rd.ReadLine(), rd.ReadLine());
            wt.WriteLine("{0}\t{1}", indent, rd.ReadLine());
            wt.WriteLine("{0}\t{1}",
                indent, IfTextFormatterUtility.RemoveSlashBracket(rd.ReadLine()));
            wt.WriteLine("{0}/>", indent);
        }

        // original_step
        private static void Format_original_step(TextReader rd, TextWriter wt)
        {
            string indent = "\t\t\t\t\t";
            wt.WriteLine("{0}<original_step {1}", indent, rd.ReadLine());
            wt.WriteLine("{0}\t{1} {2}", indent, rd.ReadLine(), rd.ReadLine());
            wt.WriteLine("{0}\t{1}", indent, rd.ReadLine());
            wt.WriteLine("{0}\t{1}",
                indent, IfTextFormatterUtility.RemoveSlashBracket(rd.ReadLine()));
            wt.WriteLine("{0}/>", indent);
        }
        #endregion

        //---------------------------------------------------------------------
    }
}
