﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Reflection;
using System.Collections.Generic;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // 中間ファイル一括処理ログユーティリティ
    public static class IfProcessLogUtility
    {
        // 作成情報を設定します
        public static void Add(nw4f_3difType nw4f_3dif,
            string process, string argument, string result)
        {
            Nintendo.Foundation.Contracts.Assertion.Argument.True((nw4f_3dif != null) && (nw4f_3dif.Item != null));
            Add(GetArray(nw4f_3dif), nw4f_3dif.Item, process, argument, result);
        }

        // 作成情報を設定します
        public static void Add(process_log_arrayType process_log_array, object data,
            string process, string argument, string result)
        {
            process_logType process_log = new process_logType();
            process_log.process = process;
            process_log.argument = argument;

            if (result != string.Empty)
            {
                /// TODO: 1.0.0 仮対応、ログ側を修正する
                process_log.Value = "\r\n\t\t" + result + "\r\n\t";
            }

            Type type = data.GetType();

            if (process_log_array == null)
            {
                PropertyInfo process_log_arrayInfo = type.GetProperty(
                    "process_log_array", typeof(process_log_arrayType));
                Nintendo.Foundation.Contracts.Assertion.Operation.True(process_log_arrayInfo != null);

                process_log_array =
                    process_log_arrayInfo.GetValue(data, null) as process_log_arrayType;

                process_log_array = new process_log_arrayType();
                process_log_array.length = 1;
                process_log_array.process_log = new process_logType[1];
                process_log_array.process_log[0] = process_log;
                process_log_arrayInfo.SetValue(data, process_log_array, null);
            }
            else
            {
                int length = process_log_array.process_log.Length;
                process_logType[] process_logs = process_log_array.process_log;
                Array.Resize(ref process_logs, length + 1);
                process_logs[length] = process_log;
                process_log.index = length;

                process_log_array.process_log = process_logs;
                process_log_array.length = length + 1;
            }
        }

        // process 名の重複した古いログを取り除きます
        public static void ToDistinctLatest(nw4f_3difType nw4f_3dif)
        {
            Nintendo.Foundation.Contracts.Assertion.Argument.True((nw4f_3dif != null) && (nw4f_3dif.Item != null));
            ToDistinctLatest(GetArray(nw4f_3dif));
        }

        // process 名の重複した古いログを取り除きます
        public static void ToDistinctLatest(process_log_arrayType process_log_array)
        {
            if (!object.ReferenceEquals(process_log_array, null))
            {
                List<process_logType> newLog = new List<process_logType>();
                for (int idxLog = 0; idxLog < process_log_array.process_log.Length - 1; ++idxLog)
                {
                    if (Array.FindIndex(process_log_array.process_log, idxLog + 1,
                        p => p.process == process_log_array.process_log[idxLog].process) < 0)
                    {
                        newLog.Add(process_log_array.process_log[idxLog]);
                    }
                }
                if (process_log_array.process_log.Length > 0)
                {
                    newLog.Add(process_log_array.process_log[process_log_array.process_log.Length - 1]);
                }
                process_log_array.process_log = newLog.ToArray();
                process_log_array.length = process_log_array.process_log.Length;
            }
        }

        // プロセスログ配列を取得します
        public static process_log_arrayType GetArray(nw4f_3difType nw4f_3dif)
        {
            Nintendo.Foundation.Contracts.Assertion.Argument.True((nw4f_3dif != null) && (nw4f_3dif.Item != null));

            object data = nw4f_3dif.Item;
            Type type = data.GetType();

            PropertyInfo process_log_arrayInfo = type.GetProperty(
                "process_log_array", typeof(process_log_arrayType));
            Nintendo.Foundation.Contracts.Assertion.Operation.True(process_log_arrayInfo != null);

            return process_log_arrayInfo.GetValue(data, null) as process_log_arrayType;
        }
    }
}
