﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/g3d_ResShapeAnim.h>
#include <g3dif/ShapeAnim.h>
#include <bindefs.h>
#include <BinaryBlock.h>
#include <BinDictionary.h>
#include <BinAnimCurve.h>
#include <BinUserData.h>

namespace nn {
namespace g3dTool {

class BinVertexShapeAnim : public BinaryBlock
{
public:
    BinVertexShapeAnim()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_CurveArray()
        , m_KeyShapeAnimCount(0)
        , m_BeginCurve(0)
        , m_BeginKeyShapeAnim(0)
    {
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_vertex_shape_anim& elem);
    virtual void CalculateSize();
    virtual void CalculateOffset( std::shared_ptr<Context> pCtx );
    virtual void Convert( std::shared_ptr<Context> pCtx );

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("VertexShapeAnim : %hs", m_pElem->shape_name.value.c_str());
    }

    int GetCurveCount() const { return static_cast<int>(m_CurveArray.size()); }
    int GetKeyShapeAnimCount() const { return m_KeyShapeAnimCount; }

    void SetBeginCurve(int beginCurve) { this->m_BeginCurve = beginCurve; }
    void SetBeginKeyShapeAnim(int beginKeyShapeAnim) { this->m_BeginKeyShapeAnim = beginKeyShapeAnim; }

private:
    const nw::g3d::tool::g3dif::elem_vertex_shape_anim* m_pElem;

    std::vector<BinAnimCurve> m_CurveArray;
    int m_KeyShapeAnimCount;
    int m_BeginCurve;
    int m_BeginKeyShapeAnim;

    enum
    {
        // BinShapeAnim に含まれる
        // VERTEX_ANIM
        ANIM_INFO,
        ChunkType_Curve,
        ChunkType_BaseValue,
        ChunkType_Count
    };

    Chunk m_Chunk[ChunkType_Count];
};

//! @brief スケルタルアニメーションデータのバイナリ化を行うクラスです。
class BinShapeAnim : public BinaryBlock
{
public:
    BinShapeAnim()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_VertexShapeAnimArray()
        , m_KeyShapeAnimCount(0)
        , m_CurveCount(0)
        , m_DicUserData()
        , m_UserDataArray()
    {
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_shape_anim& elem);
    virtual void CalculateSize();
    virtual void CalculateOffset( std::shared_ptr<Context> pCtx );
    virtual void Convert( std::shared_ptr<Context> pCtx );
    virtual void Adjust( std::shared_ptr<Context> pCtx );

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("ShapeAnim : %hs", m_pElem->name.c_str());
    }

private:
    const nw::g3d::tool::g3dif::elem_shape_anim* m_pElem;

    std::vector<BinVertexShapeAnim> m_VertexShapeAnimArray;
    int m_KeyShapeAnimCount;
    int m_CurveCount;

    BinDictionary m_DicUserData;
    std::vector<BinUserData> m_UserDataArray;

    enum ChunkType
    {
        ChunkType_BindIndex,
        ChunkType_VertexShapeAnim,
        ChunkType_UserDataData,
        ChunkType_Count
    };

    Chunk m_Chunk[ChunkType_Count];
};

}
}
