﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/g3d_ResMaterialAnim.h>
#include <g3dif/MaterialAnim.h>
#include <bindefs.h>
#include <BinaryBlock.h>
#include <BinDictionary.h>
#include <BinAnimCurve.h>
#include <BinUserData.h>
#include <BinPerMaterialAnim.h>


namespace nn {
namespace g3dTool {

//! @brief シェーダパラメータアニメーションデータのバイナリ化を行うクラスです。
class BinMaterialAnim : public BinaryBlock
{
public:
    BinMaterialAnim()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_DicUserData()
        , m_UserDataArray()
    {
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_nn_material_anim& elem);
    virtual void CalculateSize();
    virtual void CalculateOffset( std::shared_ptr<Context> pCtx );
    virtual void Convert( std::shared_ptr<Context> pCtx );
    virtual void Adjust( std::shared_ptr<Context> pCtx );

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("MaterialAnim : %hs", m_pElem->name.c_str());
    }

private:
    const nw::g3d::tool::g3dif::elem_nn_material_anim* m_pElem;

    uint16_t m_ParamCount;
    uint16_t m_CurveCount;

    BinDictionary m_DicUserData;
    std::vector<BinUserData> m_UserDataArray;
    std::vector<BinPerMaterialAnim> m_PerMaterialAnimArray;

    enum ChunkType
    {
        //SHADER_PARAM_ANIM,	// 親から貰います。
        ChunkType_BindIndex,
        ChunkType_PerMaterialAnim,
        ChunkType_UserDataData,
        ChunkType_TextureDescriptorSlotArray,
        ChunkType_GfxTextureViewPtrArray,
        ChunkType_TextureNamePtrArray,
        ChunkType_Count,
    };
    Chunk m_Chunk[ChunkType_Count];
};

}
}
