﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <bindefs.h>
#include <BinFile.h>

namespace nn {
namespace g3dTool {

// バイナリコンバートを行うクラスです。
class Converter
{
public:
    Converter()
    {
        Clear();
    }

    ~Converter()
    {
        m_Ctx.reset();
        m_File.reset();
    }

    uint32_t GetCvtrVersion() const
    {
        return NN_G3D_MODEL_SERIALIZER_VERSION;
    }

    uint32_t GetCvtrBinaryVersion() const
    {
        return NN_UTIL_CREATE_BINVERSION( NN_G3D_MODEL_BINARY_VERSION_MAJOR, NN_G3D_MODEL_BINARY_VERSION_MINOR, NN_G3D_MODEL_BINARY_VERSION_MICRO );
    }

    bool Initialize();
    bool Clear();
    bool Shutdown();
    bool SetOptions(const wchar_t* options[]);
    bool AddFile(void* pData, size_t dataSize, const wchar_t* path[3], const wchar_t* options[]);
    size_t CalculateSize();
    size_t GetAlignmentSize();
    bool Convert(void* pBuffer, size_t size);
    bool Bind(void* pBuffer, size_t size);
    bool SwapEndian(void* pBuffer, size_t size);

    template<typename T>
    void CheckVersion(T pElem, int major, int minor, int micro, const char* elementName);

    void* GetBasePtr( void ) const
    {
        return m_Ctx->GetBasePtr();
    }

    void* GetRelocationTablePtr( void ) const
    {
        return m_Ctx->GetRelocationTblPtr();
    }

    size_t GetBaseSize( void ) const
    {
        return m_Ctx->GetBaseSize();
    }

    size_t GetRelocationTableSize( void ) const
    {
        return m_Ctx->GetRelocationTblSize();
    }

private:
    std::shared_ptr<Context>	m_Ctx;
    std::unique_ptr<BinFile>	m_File;

    // オプション設定
    std::string m_RootPathUtf;
    int m_CheckFlag;
    bool m_UseAbsolutePath;

};

}
}
