﻿namespace G3dCore.Windows.Utilities
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Threading;

    /// <summary>
    /// WPF スレッドに関するユーティリティクラスです。
    /// </summary>
    public static class ThreadUtility
    {
        /// <summary>
        /// UI スレッドから同期でメソッドを実行します。
        /// </summary>
        /// <param name="action">実行するメソッドです。</param>
        public static void InvokeOnUIThread(Action action)
        {
            Debug.Assert(action != null);

            Dispatcher dispatcher = Application.Current.Dispatcher;

            if (dispatcher.CheckAccess())
            {
                action.Invoke();
            }
            else
            {
                dispatcher.Invoke(action);
            }
        }

        /// <summary>
        /// UI スレッドから非同期でメソッドを実行します。
        /// </summary>
        /// <param name="action">実行するメソッドです。</param>
        public static void BeginInvokeOnUIThread(Action action)
        {
            Debug.Assert(action != null);

            Dispatcher dispatcher = Application.Current.Dispatcher;

            if (dispatcher.CheckAccess())
            {
                action.Invoke();
            }
            else
            {
                dispatcher.BeginInvoke(action);
            }
        }
    }
}
