﻿namespace G3dCore.Modules.ErrorView
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Interactivity;
    using G3dCore.Messaging;

    /// <summary>
    /// エラービューダイアログを表示するアクションのクラスです。
    /// </summary>
    public class ErrorViewDialogAction : TriggerAction<DependencyObject>
    {
        /// <summary>
        /// アクションを呼び出します。
        /// </summary>
        /// <param name="parameter">アクションへのパラメーター。</param>
        protected override void Invoke(object parameter)
        {
            var args = parameter as MessageEventArgs;
            if (args == null)
            {
                return;
            }

            var input = (InputArg)args.Message.Body;
            var viewModel = new ErrorViewDialogViewModel(input.ErrorViewLogger);

            var dialog = new ErrorViewDialog();
            dialog.Owner = Application.Current.MainWindow;
            dialog.DataContext = viewModel;

            var output = new OutputArg();
            output.Result = dialog.ShowDialog();

            args.Message.Response = output;
            args.Callback(args.Message);
        }

        public class InputArg
        {
            public ErrorViewLogger ErrorViewLogger
            {
                get;
                set;
            }
        }

        public class OutputArg
        {
            public bool? Result
            {
                get;
                internal set;
            }
        }
    }
}
